<?php

namespace DHLExpressGlobalWS\EnumType;

/**
 * This class stands for Content EnumType
 * @subpackage Enumerations
 */
class Content
{
    /**
     * Constant for value 'DOCUMENTS'
     * @return string 'DOCUMENTS'
     */
    const VALUE_DOCUMENTS = 'DOCUMENTS';
    /**
     * Constant for value 'NON_DOCUMENTS'
     * @return string 'NON_DOCUMENTS'
     */
    const VALUE_NON_DOCUMENTS = 'NON_DOCUMENTS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DOCUMENTS
     * @uses self::VALUE_NON_DOCUMENTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DOCUMENTS,
            self::VALUE_NON_DOCUMENTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
