<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetachOptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Detach options for Transport Label, Waybill Document, Shipment Receipt and Customs Invoice
 * @subpackage Structs
 */
class DetachOptions extends AbstractStructBase
{
    /**
     * The AllInOnePDF
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $AllInOnePDF;
    /**
     * The SplitShipmentReceiptAndCustomsInvoice
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $SplitShipmentReceiptAndCustomsInvoice;
    /**
     * The SplitTransportLabelAndWaybillDocument
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $SplitTransportLabelAndWaybillDocument;
    /**
     * The SplitLabelsByPieces
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $SplitLabelsByPieces;
    /**
     * Constructor method for DetachOptions
     * @uses DetachOptions::setAllInOnePDF()
     * @uses DetachOptions::setSplitShipmentReceiptAndCustomsInvoice()
     * @uses DetachOptions::setSplitTransportLabelAndWaybillDocument()
     * @uses DetachOptions::setSplitLabelsByPieces()
     * @param string $allInOnePDF
     * @param string $splitShipmentReceiptAndCustomsInvoice
     * @param string $splitTransportLabelAndWaybillDocument
     * @param string $splitLabelsByPieces
     */
    public function __construct($allInOnePDF = 'N', $splitShipmentReceiptAndCustomsInvoice = 'N', $splitTransportLabelAndWaybillDocument = 'N', $splitLabelsByPieces = 'N')
    {
        $this
            ->setAllInOnePDF($allInOnePDF)
            ->setSplitShipmentReceiptAndCustomsInvoice($splitShipmentReceiptAndCustomsInvoice)
            ->setSplitTransportLabelAndWaybillDocument($splitTransportLabelAndWaybillDocument)
            ->setSplitLabelsByPieces($splitLabelsByPieces);
    }
    /**
     * Get AllInOnePDF value
     * @return string|null
     */
    public function getAllInOnePDF()
    {
        return $this->AllInOnePDF;
    }
    /**
     * Set AllInOnePDF value
     * @uses \DHLExpressGlobalWS\EnumType\AllInOnePDF::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\AllInOnePDF::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allInOnePDF
     * @return \DHLExpressGlobalWS\StructType\DetachOptions
     */
    public function setAllInOnePDF($allInOnePDF = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\AllInOnePDF::valueIsValid($allInOnePDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\AllInOnePDF', is_array($allInOnePDF) ? implode(', ', $allInOnePDF) : var_export($allInOnePDF, true), implode(', ', \DHLExpressGlobalWS\EnumType\AllInOnePDF::getValidValues())), __LINE__);
        }
        $this->AllInOnePDF = $allInOnePDF;
        return $this;
    }
    /**
     * Get SplitShipmentReceiptAndCustomsInvoice value
     * @return string|null
     */
    public function getSplitShipmentReceiptAndCustomsInvoice()
    {
        return $this->SplitShipmentReceiptAndCustomsInvoice;
    }
    /**
     * Set SplitShipmentReceiptAndCustomsInvoice value
     * @uses \DHLExpressGlobalWS\EnumType\SplitShipmentReceiptAndCustomsInvoice::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\SplitShipmentReceiptAndCustomsInvoice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splitShipmentReceiptAndCustomsInvoice
     * @return \DHLExpressGlobalWS\StructType\DetachOptions
     */
    public function setSplitShipmentReceiptAndCustomsInvoice($splitShipmentReceiptAndCustomsInvoice = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\SplitShipmentReceiptAndCustomsInvoice::valueIsValid($splitShipmentReceiptAndCustomsInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\SplitShipmentReceiptAndCustomsInvoice', is_array($splitShipmentReceiptAndCustomsInvoice) ? implode(', ', $splitShipmentReceiptAndCustomsInvoice) : var_export($splitShipmentReceiptAndCustomsInvoice, true), implode(', ', \DHLExpressGlobalWS\EnumType\SplitShipmentReceiptAndCustomsInvoice::getValidValues())), __LINE__);
        }
        $this->SplitShipmentReceiptAndCustomsInvoice = $splitShipmentReceiptAndCustomsInvoice;
        return $this;
    }
    /**
     * Get SplitTransportLabelAndWaybillDocument value
     * @return string|null
     */
    public function getSplitTransportLabelAndWaybillDocument()
    {
        return $this->SplitTransportLabelAndWaybillDocument;
    }
    /**
     * Set SplitTransportLabelAndWaybillDocument value
     * @uses \DHLExpressGlobalWS\EnumType\SplitTransportLabelAndWaybillDocument::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\SplitTransportLabelAndWaybillDocument::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splitTransportLabelAndWaybillDocument
     * @return \DHLExpressGlobalWS\StructType\DetachOptions
     */
    public function setSplitTransportLabelAndWaybillDocument($splitTransportLabelAndWaybillDocument = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\SplitTransportLabelAndWaybillDocument::valueIsValid($splitTransportLabelAndWaybillDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\SplitTransportLabelAndWaybillDocument', is_array($splitTransportLabelAndWaybillDocument) ? implode(', ', $splitTransportLabelAndWaybillDocument) : var_export($splitTransportLabelAndWaybillDocument, true), implode(', ', \DHLExpressGlobalWS\EnumType\SplitTransportLabelAndWaybillDocument::getValidValues())), __LINE__);
        }
        $this->SplitTransportLabelAndWaybillDocument = $splitTransportLabelAndWaybillDocument;
        return $this;
    }
    /**
     * Get SplitLabelsByPieces value
     * @return string|null
     */
    public function getSplitLabelsByPieces()
    {
        return $this->SplitLabelsByPieces;
    }
    /**
     * Set SplitLabelsByPieces value
     * @uses \DHLExpressGlobalWS\EnumType\SplitLabelsByPieces::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\SplitLabelsByPieces::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $splitLabelsByPieces
     * @return \DHLExpressGlobalWS\StructType\DetachOptions
     */
    public function setSplitLabelsByPieces($splitLabelsByPieces = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\SplitLabelsByPieces::valueIsValid($splitLabelsByPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\SplitLabelsByPieces', is_array($splitLabelsByPieces) ? implode(', ', $splitLabelsByPieces) : var_export($splitLabelsByPieces, true), implode(', ', \DHLExpressGlobalWS\EnumType\SplitLabelsByPieces::getValidValues())), __LINE__);
        }
        $this->SplitLabelsByPieces = $splitLabelsByPieces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DetachOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
