<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalInformation StructType
 * @subpackage Structs
 */
class AdditionalInformation extends AbstractStructBase
{
    /**
     * The BillingCode
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $BillingCode;
    /**
     * The OriginServiceArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_OriginServiceAreaType
     */
    public $OriginServiceArea;
    /**
     * The DestinationServiceArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_DestinationServiceAreaType
     */
    public $DestinationServiceArea;
    /**
     * The Ship
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType
     */
    public $Ship;
    /**
     * The VolumetricWeight
     * Meta information extracted from the WSDL
     * - documentation: Dimensional Weight
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $VolumetricWeight;
    /**
     * The CutoffTime
     * Meta information extracted from the WSDL
     * - documentation: Identifies the cutoff date and time the package needs to be tendered to the shipper, in order to meet the estimated delivery time.The time is the local time of the shipment based on the shipper's time zone. The date component must be
     * in the format:YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g. 2006-06-26T17:00:00).
     * - minOccurs: 0
     * @var string
     */
    public $CutoffTime;
    /**
     * The DHLRoutingCode
     * Meta information extracted from the WSDL
     * - documentation: Routing Code
     * - minOccurs: 0
     * @var string
     */
    public $DHLRoutingCode;
    /**
     * The DHLRoutingDataID
     * Meta information extracted from the WSDL
     * - documentation: Routing Code Identifier
     * - minOccurs: 0
     * @var string
     */
    public $DHLRoutingDataID;
    /**
     * The ServiceContentCode
     * Meta information extracted from the WSDL
     * - documentation: Product Content Code
     * - base: xsd:token
     * - maxLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ServiceContentCode;
    /**
     * The ServiceHandlingFeatureCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes
     */
    public $ServiceHandlingFeatureCodes;
    /**
     * The DeliveryDateCode
     * Meta information extracted from the WSDL
     * - documentation: Delivery Date Code
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDateCode;
    /**
     * The DeliveryTimeCode
     * Meta information extracted from the WSDL
     * - documentation: Delivery Time Code
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTimeCode;
    /**
     * Constructor method for AdditionalInformation
     * @uses AdditionalInformation::setBillingCode()
     * @uses AdditionalInformation::setOriginServiceArea()
     * @uses AdditionalInformation::setDestinationServiceArea()
     * @uses AdditionalInformation::setShip()
     * @uses AdditionalInformation::setVolumetricWeight()
     * @uses AdditionalInformation::setCutoffTime()
     * @uses AdditionalInformation::setDHLRoutingCode()
     * @uses AdditionalInformation::setDHLRoutingDataID()
     * @uses AdditionalInformation::setServiceContentCode()
     * @uses AdditionalInformation::setServiceHandlingFeatureCodes()
     * @uses AdditionalInformation::setDeliveryDateCode()
     * @uses AdditionalInformation::setDeliveryTimeCode()
     * @param string $billingCode
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType $ship
     * @param float $volumetricWeight
     * @param string $cutoffTime
     * @param string $dHLRoutingCode
     * @param string $dHLRoutingDataID
     * @param string $serviceContentCode
     * @param \DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes
     * @param string $deliveryDateCode
     * @param string $deliveryTimeCode
     */
    public function __construct($billingCode = null, \DHLExpressGlobalWS\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea = null, \DHLExpressGlobalWS\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea = null, \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType $ship = null, $volumetricWeight = null, $cutoffTime = null, $dHLRoutingCode = null, $dHLRoutingDataID = null, $serviceContentCode = null, \DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes = null, $deliveryDateCode = null, $deliveryTimeCode = null)
    {
        $this
            ->setBillingCode($billingCode)
            ->setOriginServiceArea($originServiceArea)
            ->setDestinationServiceArea($destinationServiceArea)
            ->setShip($ship)
            ->setVolumetricWeight($volumetricWeight)
            ->setCutoffTime($cutoffTime)
            ->setDHLRoutingCode($dHLRoutingCode)
            ->setDHLRoutingDataID($dHLRoutingDataID)
            ->setServiceContentCode($serviceContentCode)
            ->setServiceHandlingFeatureCodes($serviceHandlingFeatureCodes)
            ->setDeliveryDateCode($deliveryDateCode)
            ->setDeliveryTimeCode($deliveryTimeCode);
    }
    /**
     * Get BillingCode value
     * @return string|null
     */
    public function getBillingCode()
    {
        return $this->BillingCode;
    }
    /**
     * Set BillingCode value
     * @param string $billingCode
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setBillingCode($billingCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingCode) && !is_string($billingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingCode, true), gettype($billingCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($billingCode) && mb_strlen($billingCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($billingCode)), __LINE__);
        }
        $this->BillingCode = $billingCode;
        return $this;
    }
    /**
     * Get OriginServiceArea value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_OriginServiceAreaType|null
     */
    public function getOriginServiceArea()
    {
        return $this->OriginServiceArea;
    }
    /**
     * Set OriginServiceArea value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setOriginServiceArea(\DHLExpressGlobalWS\StructType\DocTypeRef_OriginServiceAreaType $originServiceArea = null)
    {
        $this->OriginServiceArea = $originServiceArea;
        return $this;
    }
    /**
     * Get DestinationServiceArea value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DestinationServiceAreaType|null
     */
    public function getDestinationServiceArea()
    {
        return $this->DestinationServiceArea;
    }
    /**
     * Set DestinationServiceArea value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setDestinationServiceArea(\DHLExpressGlobalWS\StructType\DocTypeRef_DestinationServiceAreaType $destinationServiceArea = null)
    {
        $this->DestinationServiceArea = $destinationServiceArea;
        return $this;
    }
    /**
     * Get Ship value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ShipType $ship
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setShip(\DHLExpressGlobalWS\StructType\DocTypeRef_ShipType $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get VolumetricWeight value
     * @return float|null
     */
    public function getVolumetricWeight()
    {
        return $this->VolumetricWeight;
    }
    /**
     * Set VolumetricWeight value
     * @param float $volumetricWeight
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setVolumetricWeight($volumetricWeight = null)
    {
        // validation for constraint: float
        if (!is_null($volumetricWeight) && !(is_float($volumetricWeight) || is_numeric($volumetricWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volumetricWeight, true), gettype($volumetricWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($volumetricWeight) && mb_strlen(mb_substr($volumetricWeight, mb_strpos($volumetricWeight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($volumetricWeight, true), mb_strlen(mb_substr($volumetricWeight, mb_strpos($volumetricWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($volumetricWeight) && mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($volumetricWeight, true), mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight))), __LINE__);
        }
        $this->VolumetricWeight = $volumetricWeight;
        return $this;
    }
    /**
     * Get CutoffTime value
     * @return string|null
     */
    public function getCutoffTime()
    {
        return $this->CutoffTime;
    }
    /**
     * Set CutoffTime value
     * @param string $cutoffTime
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setCutoffTime($cutoffTime = null)
    {
        // validation for constraint: string
        if (!is_null($cutoffTime) && !is_string($cutoffTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cutoffTime, true), gettype($cutoffTime)), __LINE__);
        }
        $this->CutoffTime = $cutoffTime;
        return $this;
    }
    /**
     * Get DHLRoutingCode value
     * @return string|null
     */
    public function getDHLRoutingCode()
    {
        return $this->DHLRoutingCode;
    }
    /**
     * Set DHLRoutingCode value
     * @param string $dHLRoutingCode
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setDHLRoutingCode($dHLRoutingCode = null)
    {
        // validation for constraint: string
        if (!is_null($dHLRoutingCode) && !is_string($dHLRoutingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLRoutingCode, true), gettype($dHLRoutingCode)), __LINE__);
        }
        $this->DHLRoutingCode = $dHLRoutingCode;
        return $this;
    }
    /**
     * Get DHLRoutingDataID value
     * @return string|null
     */
    public function getDHLRoutingDataID()
    {
        return $this->DHLRoutingDataID;
    }
    /**
     * Set DHLRoutingDataID value
     * @param string $dHLRoutingDataID
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setDHLRoutingDataID($dHLRoutingDataID = null)
    {
        // validation for constraint: string
        if (!is_null($dHLRoutingDataID) && !is_string($dHLRoutingDataID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLRoutingDataID, true), gettype($dHLRoutingDataID)), __LINE__);
        }
        $this->DHLRoutingDataID = $dHLRoutingDataID;
        return $this;
    }
    /**
     * Get ServiceContentCode value
     * @return string|null
     */
    public function getServiceContentCode()
    {
        return $this->ServiceContentCode;
    }
    /**
     * Set ServiceContentCode value
     * @param string $serviceContentCode
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setServiceContentCode($serviceContentCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceContentCode) && !is_string($serviceContentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceContentCode, true), gettype($serviceContentCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($serviceContentCode) && mb_strlen($serviceContentCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($serviceContentCode)), __LINE__);
        }
        $this->ServiceContentCode = $serviceContentCode;
        return $this;
    }
    /**
     * Get ServiceHandlingFeatureCodes value
     * @return \DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes|null
     */
    public function getServiceHandlingFeatureCodes()
    {
        return $this->ServiceHandlingFeatureCodes;
    }
    /**
     * Set ServiceHandlingFeatureCodes value
     * @param \DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setServiceHandlingFeatureCodes(\DHLExpressGlobalWS\StructType\ServiceHandlingFeatureCodes $serviceHandlingFeatureCodes = null)
    {
        $this->ServiceHandlingFeatureCodes = $serviceHandlingFeatureCodes;
        return $this;
    }
    /**
     * Get DeliveryDateCode value
     * @return string|null
     */
    public function getDeliveryDateCode()
    {
        return $this->DeliveryDateCode;
    }
    /**
     * Set DeliveryDateCode value
     * @param string $deliveryDateCode
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setDeliveryDateCode($deliveryDateCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDateCode) && !is_string($deliveryDateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDateCode, true), gettype($deliveryDateCode)), __LINE__);
        }
        $this->DeliveryDateCode = $deliveryDateCode;
        return $this;
    }
    /**
     * Get DeliveryTimeCode value
     * @return string|null
     */
    public function getDeliveryTimeCode()
    {
        return $this->DeliveryTimeCode;
    }
    /**
     * Set DeliveryTimeCode value
     * @param string $deliveryTimeCode
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public function setDeliveryTimeCode($deliveryTimeCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTimeCode) && !is_string($deliveryTimeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTimeCode, true), gettype($deliveryTimeCode)), __LINE__);
        }
        $this->DeliveryTimeCode = $deliveryTimeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\AdditionalInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
