<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelOptions StructType
 * Meta informations extracted from the WSDL
 * - documentation: Label options that available for transport label, waybill document, shipment receipt and custom invoice document
 * @subpackage Structs
 */
class LabelOptions extends AbstractStructBase
{
    /**
     * The CustomerLogo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\CustomerLogo
     */
    public $CustomerLogo;
    /**
     * The CustomerBarcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\CustomerBarcode
     */
    public $CustomerBarcode;
    /**
     * The PrinterDPI
     * Meta informations extracted from the WSDL
     * - documentation: Printer DPI Resolution for X-axis and Y-axis (in DPI) for transport label and waybill document output
     * - base: xsd:positiveInteger
     * - maxInclusive: 300
     * - minInclusive: 200
     * - minOccurs: 0
     * @var int
     */
    public $PrinterDPI;
    /**
     * The RequestWaybillDocument
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestWaybillDocument;
    /**
     * The HideAccountInWaybillDocument
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $HideAccountInWaybillDocument;
    /**
     * The NumberOfWaybillDocumentCopies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfWaybillDocumentCopies;
    /**
     * The RequestDHLCustomsInvoice
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestDHLCustomsInvoice;
    /**
     * The DHLCustomsInvoiceLanguageCode
     * Meta informations extracted from the WSDL
     * - documentation: DHL Customs Invoice Language Code | eng for English
     * - base: xsd:string
     * - default: eng
     * - maxLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $DHLCustomsInvoiceLanguageCode;
    /**
     * The DHLCustomsInvoiceType
     * Meta informations extracted from the WSDL
     * - default: COMMERCIAL_INVOICE
     * - minOccurs: 0
     * @var string
     */
    public $DHLCustomsInvoiceType;
    /**
     * The RequestShipmentReceipt
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestShipmentReceipt;
    /**
     * The DetachOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DetachOptions
     */
    public $DetachOptions;
    /**
     * Constructor method for LabelOptions
     * @uses LabelOptions::setCustomerLogo()
     * @uses LabelOptions::setCustomerBarcode()
     * @uses LabelOptions::setPrinterDPI()
     * @uses LabelOptions::setRequestWaybillDocument()
     * @uses LabelOptions::setHideAccountInWaybillDocument()
     * @uses LabelOptions::setNumberOfWaybillDocumentCopies()
     * @uses LabelOptions::setRequestDHLCustomsInvoice()
     * @uses LabelOptions::setDHLCustomsInvoiceLanguageCode()
     * @uses LabelOptions::setDHLCustomsInvoiceType()
     * @uses LabelOptions::setRequestShipmentReceipt()
     * @uses LabelOptions::setDetachOptions()
     * @param \DHLExpressGlobalWS\StructType\CustomerLogo $customerLogo
     * @param \DHLExpressGlobalWS\StructType\CustomerBarcode $customerBarcode
     * @param int $printerDPI
     * @param string $requestWaybillDocument
     * @param string $hideAccountInWaybillDocument
     * @param string $numberOfWaybillDocumentCopies
     * @param string $requestDHLCustomsInvoice
     * @param string $dHLCustomsInvoiceLanguageCode
     * @param string $dHLCustomsInvoiceType
     * @param string $requestShipmentReceipt
     * @param \DHLExpressGlobalWS\StructType\DetachOptions $detachOptions
     */
    public function __construct(\DHLExpressGlobalWS\StructType\CustomerLogo $customerLogo = null, \DHLExpressGlobalWS\StructType\CustomerBarcode $customerBarcode = null, $printerDPI = null, $requestWaybillDocument = 'N', $hideAccountInWaybillDocument = 'N', $numberOfWaybillDocumentCopies = null, $requestDHLCustomsInvoice = 'N', $dHLCustomsInvoiceLanguageCode = 'eng', $dHLCustomsInvoiceType = 'COMMERCIAL_INVOICE', $requestShipmentReceipt = 'N', \DHLExpressGlobalWS\StructType\DetachOptions $detachOptions = null)
    {
        $this
            ->setCustomerLogo($customerLogo)
            ->setCustomerBarcode($customerBarcode)
            ->setPrinterDPI($printerDPI)
            ->setRequestWaybillDocument($requestWaybillDocument)
            ->setHideAccountInWaybillDocument($hideAccountInWaybillDocument)
            ->setNumberOfWaybillDocumentCopies($numberOfWaybillDocumentCopies)
            ->setRequestDHLCustomsInvoice($requestDHLCustomsInvoice)
            ->setDHLCustomsInvoiceLanguageCode($dHLCustomsInvoiceLanguageCode)
            ->setDHLCustomsInvoiceType($dHLCustomsInvoiceType)
            ->setRequestShipmentReceipt($requestShipmentReceipt)
            ->setDetachOptions($detachOptions);
    }
    /**
     * Get CustomerLogo value
     * @return \DHLExpressGlobalWS\StructType\CustomerLogo|null
     */
    public function getCustomerLogo()
    {
        return $this->CustomerLogo;
    }
    /**
     * Set CustomerLogo value
     * @param \DHLExpressGlobalWS\StructType\CustomerLogo $customerLogo
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setCustomerLogo(\DHLExpressGlobalWS\StructType\CustomerLogo $customerLogo = null)
    {
        $this->CustomerLogo = $customerLogo;
        return $this;
    }
    /**
     * Get CustomerBarcode value
     * @return \DHLExpressGlobalWS\StructType\CustomerBarcode|null
     */
    public function getCustomerBarcode()
    {
        return $this->CustomerBarcode;
    }
    /**
     * Set CustomerBarcode value
     * @param \DHLExpressGlobalWS\StructType\CustomerBarcode $customerBarcode
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setCustomerBarcode(\DHLExpressGlobalWS\StructType\CustomerBarcode $customerBarcode = null)
    {
        $this->CustomerBarcode = $customerBarcode;
        return $this;
    }
    /**
     * Get PrinterDPI value
     * @return int|null
     */
    public function getPrinterDPI()
    {
        return $this->PrinterDPI;
    }
    /**
     * Set PrinterDPI value
     * @param int $printerDPI
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setPrinterDPI($printerDPI = null)
    {
        // validation for constraint: int
        if (!is_null($printerDPI) && !(is_int($printerDPI) || ctype_digit($printerDPI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printerDPI, true), gettype($printerDPI)), __LINE__);
        }
        // validation for constraint: maxInclusive(300)
        if (!is_null($printerDPI) && $printerDPI > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 300', var_export($printerDPI, true)), __LINE__);
        }
        // validation for constraint: minInclusive(200)
        if (!is_null($printerDPI) && $printerDPI < 200) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 200', var_export($printerDPI, true)), __LINE__);
        }
        $this->PrinterDPI = $printerDPI;
        return $this;
    }
    /**
     * Get RequestWaybillDocument value
     * @return string|null
     */
    public function getRequestWaybillDocument()
    {
        return $this->RequestWaybillDocument;
    }
    /**
     * Set RequestWaybillDocument value
     * @uses \DHLExpressGlobalWS\EnumType\RequestWaybillDocument::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\RequestWaybillDocument::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestWaybillDocument
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setRequestWaybillDocument($requestWaybillDocument = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\RequestWaybillDocument::valueIsValid($requestWaybillDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\RequestWaybillDocument', is_array($requestWaybillDocument) ? implode(', ', $requestWaybillDocument) : var_export($requestWaybillDocument, true), implode(', ', \DHLExpressGlobalWS\EnumType\RequestWaybillDocument::getValidValues())), __LINE__);
        }
        $this->RequestWaybillDocument = $requestWaybillDocument;
        return $this;
    }
    /**
     * Get HideAccountInWaybillDocument value
     * @return string|null
     */
    public function getHideAccountInWaybillDocument()
    {
        return $this->HideAccountInWaybillDocument;
    }
    /**
     * Set HideAccountInWaybillDocument value
     * @uses \DHLExpressGlobalWS\EnumType\HideAccountInWaybillDocument::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\HideAccountInWaybillDocument::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hideAccountInWaybillDocument
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setHideAccountInWaybillDocument($hideAccountInWaybillDocument = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\HideAccountInWaybillDocument::valueIsValid($hideAccountInWaybillDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\HideAccountInWaybillDocument', is_array($hideAccountInWaybillDocument) ? implode(', ', $hideAccountInWaybillDocument) : var_export($hideAccountInWaybillDocument, true), implode(', ', \DHLExpressGlobalWS\EnumType\HideAccountInWaybillDocument::getValidValues())), __LINE__);
        }
        $this->HideAccountInWaybillDocument = $hideAccountInWaybillDocument;
        return $this;
    }
    /**
     * Get NumberOfWaybillDocumentCopies value
     * @return string|null
     */
    public function getNumberOfWaybillDocumentCopies()
    {
        return $this->NumberOfWaybillDocumentCopies;
    }
    /**
     * Set NumberOfWaybillDocumentCopies value
     * @uses \DHLExpressGlobalWS\EnumType\NumberOfWaybillDocumentCopies::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\NumberOfWaybillDocumentCopies::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfWaybillDocumentCopies
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setNumberOfWaybillDocumentCopies($numberOfWaybillDocumentCopies = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\NumberOfWaybillDocumentCopies::valueIsValid($numberOfWaybillDocumentCopies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\NumberOfWaybillDocumentCopies', is_array($numberOfWaybillDocumentCopies) ? implode(', ', $numberOfWaybillDocumentCopies) : var_export($numberOfWaybillDocumentCopies, true), implode(', ', \DHLExpressGlobalWS\EnumType\NumberOfWaybillDocumentCopies::getValidValues())), __LINE__);
        }
        $this->NumberOfWaybillDocumentCopies = $numberOfWaybillDocumentCopies;
        return $this;
    }
    /**
     * Get RequestDHLCustomsInvoice value
     * @return string|null
     */
    public function getRequestDHLCustomsInvoice()
    {
        return $this->RequestDHLCustomsInvoice;
    }
    /**
     * Set RequestDHLCustomsInvoice value
     * @uses \DHLExpressGlobalWS\EnumType\RequestDHLCustomsInvoice::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\RequestDHLCustomsInvoice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestDHLCustomsInvoice
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setRequestDHLCustomsInvoice($requestDHLCustomsInvoice = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\RequestDHLCustomsInvoice::valueIsValid($requestDHLCustomsInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\RequestDHLCustomsInvoice', is_array($requestDHLCustomsInvoice) ? implode(', ', $requestDHLCustomsInvoice) : var_export($requestDHLCustomsInvoice, true), implode(', ', \DHLExpressGlobalWS\EnumType\RequestDHLCustomsInvoice::getValidValues())), __LINE__);
        }
        $this->RequestDHLCustomsInvoice = $requestDHLCustomsInvoice;
        return $this;
    }
    /**
     * Get DHLCustomsInvoiceLanguageCode value
     * @return string|null
     */
    public function getDHLCustomsInvoiceLanguageCode()
    {
        return $this->DHLCustomsInvoiceLanguageCode;
    }
    /**
     * Set DHLCustomsInvoiceLanguageCode value
     * @param string $dHLCustomsInvoiceLanguageCode
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setDHLCustomsInvoiceLanguageCode($dHLCustomsInvoiceLanguageCode = 'eng')
    {
        // validation for constraint: string
        if (!is_null($dHLCustomsInvoiceLanguageCode) && !is_string($dHLCustomsInvoiceLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLCustomsInvoiceLanguageCode, true), gettype($dHLCustomsInvoiceLanguageCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($dHLCustomsInvoiceLanguageCode) && mb_strlen($dHLCustomsInvoiceLanguageCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($dHLCustomsInvoiceLanguageCode)), __LINE__);
        }
        $this->DHLCustomsInvoiceLanguageCode = $dHLCustomsInvoiceLanguageCode;
        return $this;
    }
    /**
     * Get DHLCustomsInvoiceType value
     * @return string|null
     */
    public function getDHLCustomsInvoiceType()
    {
        return $this->DHLCustomsInvoiceType;
    }
    /**
     * Set DHLCustomsInvoiceType value
     * @uses \DHLExpressGlobalWS\EnumType\DHLCustomsInvoiceType::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\DHLCustomsInvoiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dHLCustomsInvoiceType
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setDHLCustomsInvoiceType($dHLCustomsInvoiceType = 'COMMERCIAL_INVOICE')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\DHLCustomsInvoiceType::valueIsValid($dHLCustomsInvoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\DHLCustomsInvoiceType', is_array($dHLCustomsInvoiceType) ? implode(', ', $dHLCustomsInvoiceType) : var_export($dHLCustomsInvoiceType, true), implode(', ', \DHLExpressGlobalWS\EnumType\DHLCustomsInvoiceType::getValidValues())), __LINE__);
        }
        $this->DHLCustomsInvoiceType = $dHLCustomsInvoiceType;
        return $this;
    }
    /**
     * Get RequestShipmentReceipt value
     * @return string|null
     */
    public function getRequestShipmentReceipt()
    {
        return $this->RequestShipmentReceipt;
    }
    /**
     * Set RequestShipmentReceipt value
     * @uses \DHLExpressGlobalWS\EnumType\RequestShipmentReceipt::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\RequestShipmentReceipt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestShipmentReceipt
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setRequestShipmentReceipt($requestShipmentReceipt = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\RequestShipmentReceipt::valueIsValid($requestShipmentReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\RequestShipmentReceipt', is_array($requestShipmentReceipt) ? implode(', ', $requestShipmentReceipt) : var_export($requestShipmentReceipt, true), implode(', ', \DHLExpressGlobalWS\EnumType\RequestShipmentReceipt::getValidValues())), __LINE__);
        }
        $this->RequestShipmentReceipt = $requestShipmentReceipt;
        return $this;
    }
    /**
     * Get DetachOptions value
     * @return \DHLExpressGlobalWS\StructType\DetachOptions|null
     */
    public function getDetachOptions()
    {
        return $this->DetachOptions;
    }
    /**
     * Set DetachOptions value
     * @param \DHLExpressGlobalWS\StructType\DetachOptions $detachOptions
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public function setDetachOptions(\DHLExpressGlobalWS\StructType\DetachOptions $detachOptions = null)
    {
        $this->DetachOptions = $detachOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\LabelOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
