<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_Document StructType
 * @subpackage Structs
 */
class DocTypeRef_Document extends AbstractStructBase
{
    /**
     * The DocumentName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the document
     * @var string
     */
    public $DocumentName;
    /**
     * The DocumentFormat
     * Meta informations extracted from the WSDL
     * - documentation: Format of the document
     * - base: xsd:token
     * - maxLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $DocumentFormat;
    /**
     * The DocumentImage
     * Meta informations extracted from the WSDL
     * - documentation: Image of the document
     * @var string
     */
    public $DocumentImage;
    /**
     * Constructor method for docTypeRef_Document
     * @uses DocTypeRef_Document::setDocumentName()
     * @uses DocTypeRef_Document::setDocumentFormat()
     * @uses DocTypeRef_Document::setDocumentImage()
     * @param string $documentName
     * @param string $documentFormat
     * @param string $documentImage
     */
    public function __construct($documentName = null, $documentFormat = null, $documentImage = null)
    {
        $this
            ->setDocumentName($documentName)
            ->setDocumentFormat($documentFormat)
            ->setDocumentImage($documentImage);
    }
    /**
     * Get DocumentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->DocumentName;
    }
    /**
     * Set DocumentName value
     * @param string $documentName
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_Document
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        $this->DocumentName = $documentName;
        return $this;
    }
    /**
     * Get DocumentFormat value
     * @return string|null
     */
    public function getDocumentFormat()
    {
        return $this->DocumentFormat;
    }
    /**
     * Set DocumentFormat value
     * @param string $documentFormat
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_Document
     */
    public function setDocumentFormat($documentFormat = null)
    {
        // validation for constraint: string
        if (!is_null($documentFormat) && !is_string($documentFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentFormat, true), gettype($documentFormat)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($documentFormat) && mb_strlen($documentFormat) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($documentFormat)), __LINE__);
        }
        $this->DocumentFormat = $documentFormat;
        return $this;
    }
    /**
     * Get DocumentImage value
     * @return string|null
     */
    public function getDocumentImage()
    {
        return $this->DocumentImage;
    }
    /**
     * Set DocumentImage value
     * @param string $documentImage
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_Document
     */
    public function setDocumentImage($documentImage = null)
    {
        // validation for constraint: string
        if (!is_null($documentImage) && !is_string($documentImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentImage, true), gettype($documentImage)), __LINE__);
        }
        $this->DocumentImage = $documentImage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
