<?php

namespace DHLExpressGlobalWS\EnumType;

/**
 * This class stands for SplitLabelsByPieces EnumType
 * Meta informations extracted from the WSDL
 * - documentation: single PDF or thermal output file for each pieces in Transport Label, Single PDF or thermal output file for Waybill Document (for regular shipment - dutiable shipment), and Single PDF of Shipment Receipt + Customs Invoice
 * @subpackage Enumerations
 */
class SplitLabelsByPieces
{
    /**
     * Constant for value 'Y'
     * @return string 'Y'
     */
    const VALUE_Y = 'Y';
    /**
     * Constant for value 'N'
     * @return string 'N'
     */
    const VALUE_N = 'N';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_Y
     * @uses self::VALUE_N
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_Y,
            self::VALUE_N,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
