<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAndServices StructType
 * @subpackage Structs
 */
class ProductAndServices extends AbstractStructBase
{
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: DHL global product code
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $ServiceType;
    /**
     * The LocalServiceType
     * Meta informations extracted from the WSDL
     * - documentation: Local Product Code | Optional DHL local product code
     * - base: xsd:string
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalServiceType;
    /**
     * The SpecialServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\Services2
     */
    public $SpecialServices;
    /**
     * Constructor method for ProductAndServices
     * @uses ProductAndServices::setServiceType()
     * @uses ProductAndServices::setLocalServiceType()
     * @uses ProductAndServices::setSpecialServices()
     * @param string $serviceType
     * @param string $localServiceType
     * @param \DHLExpressGlobalWS\StructType\Services2 $specialServices
     */
    public function __construct($serviceType = null, $localServiceType = null, \DHLExpressGlobalWS\StructType\Services2 $specialServices = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setLocalServiceType($localServiceType)
            ->setSpecialServices($specialServices);
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \DHLExpressGlobalWS\StructType\ProductAndServices
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($serviceType) && mb_strlen($serviceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($serviceType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($serviceType) && mb_strlen($serviceType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get LocalServiceType value
     * @return string|null
     */
    public function getLocalServiceType()
    {
        return $this->LocalServiceType;
    }
    /**
     * Set LocalServiceType value
     * @param string $localServiceType
     * @return \DHLExpressGlobalWS\StructType\ProductAndServices
     */
    public function setLocalServiceType($localServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($localServiceType) && !is_string($localServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localServiceType, true), gettype($localServiceType)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($localServiceType) && mb_strlen($localServiceType) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($localServiceType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($localServiceType) && mb_strlen($localServiceType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($localServiceType)), __LINE__);
        }
        $this->LocalServiceType = $localServiceType;
        return $this;
    }
    /**
     * Get SpecialServices value
     * @return \DHLExpressGlobalWS\StructType\Services2|null
     */
    public function getSpecialServices()
    {
        return $this->SpecialServices;
    }
    /**
     * Set SpecialServices value
     * @param \DHLExpressGlobalWS\StructType\Services2 $specialServices
     * @return \DHLExpressGlobalWS\StructType\ProductAndServices
     */
    public function setSpecialServices(\DHLExpressGlobalWS\StructType\Services2 $specialServices = null)
    {
        $this->SpecialServices = $specialServices;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\ProductAndServices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
