<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RegistrationNumbers StructType
 * @subpackage Structs
 */
class DocTypeRef_RegistrationNumbers extends AbstractStructBase
{
    /**
     * The RegistrationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 50
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber[]
     */
    public $RegistrationNumber;
    /**
     * Constructor method for docTypeRef_RegistrationNumbers
     * @uses DocTypeRef_RegistrationNumbers::setRegistrationNumber()
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber[] $registrationNumber
     */
    public function __construct(array $registrationNumber = array())
    {
        $this
            ->setRegistrationNumber($registrationNumber);
    }
    /**
     * Get RegistrationNumber value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber[]|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setRegistrationNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegistrationNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegistrationNumberForArrayConstraintsFromSetRegistrationNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_RegistrationNumbersRegistrationNumberItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_RegistrationNumbersRegistrationNumberItem instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber) {
                $invalidValues[] = is_object($docTypeRef_RegistrationNumbersRegistrationNumberItem) ? get_class($docTypeRef_RegistrationNumbersRegistrationNumberItem) : sprintf('%s(%s)', gettype($docTypeRef_RegistrationNumbersRegistrationNumberItem), var_export($docTypeRef_RegistrationNumbersRegistrationNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RegistrationNumber property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RegistrationNumber value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber[] $registrationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumbers
     */
    public function setRegistrationNumber(array $registrationNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($registrationNumberArrayErrorMessage = self::validateRegistrationNumberForArrayConstraintsFromSetRegistrationNumber($registrationNumber))) {
            throw new \InvalidArgumentException($registrationNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($registrationNumber) && count($registrationNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($registrationNumber)), __LINE__);
        }
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Add item to RegistrationNumber value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber $item
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumbers
     */
    public function addToRegistrationNumber(\DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber) {
            throw new \InvalidArgumentException(sprintf('The RegistrationNumber property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->RegistrationNumber) && count($this->RegistrationNumber) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->RegistrationNumber)), __LINE__);
        }
        $this->RegistrationNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RegistrationNumbers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
