<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_DeleteRequestType StructType
 * @subpackage Structs
 */
class DocTypeRef_DeleteRequestType extends AbstractStructBase
{
    /**
     * The ClientDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_ClientDetailType
     */
    public $ClientDetail;
    /**
     * The Request
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\RequestType
     */
    public $Request;
    /**
     * The PickupDate
     * Meta informations extracted from the WSDL
     * - documentation: The scheduled pickup date of the shipment to be deleted
     * @var string
     */
    public $PickupDate;
    /**
     * The PickupCountry
     * Meta informations extracted from the WSDL
     * - documentation: The country code associated to the origin of the shipment | ISO 2 character codes of the Shipper/Recipient country
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 2
     * - whiteSpace: collapse
     * @var string
     */
    public $PickupCountry;
    /**
     * The DispatchConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: The confirmation number returned from the original shipment request
     * - base: xsd:token
     * - whiteSpace: collapse
     * @var string
     */
    public $DispatchConfirmationNumber;
    /**
     * The RequestorName
     * Meta informations extracted from the WSDL
     * - documentation: The delete requestor name
     * - base: xsd:token
     * - maxLength: 45
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $RequestorName;
    /**
     * The Reason
     * Meta informations extracted from the WSDL
     * - documentation: Optional reason code. Please refer in the Developer Guide for the valid reason code
     * - base: xsd:token
     * - maxLength: 50
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for docTypeRef_DeleteRequestType
     * @uses DocTypeRef_DeleteRequestType::setClientDetail()
     * @uses DocTypeRef_DeleteRequestType::setRequest()
     * @uses DocTypeRef_DeleteRequestType::setPickupDate()
     * @uses DocTypeRef_DeleteRequestType::setPickupCountry()
     * @uses DocTypeRef_DeleteRequestType::setDispatchConfirmationNumber()
     * @uses DocTypeRef_DeleteRequestType::setRequestorName()
     * @uses DocTypeRef_DeleteRequestType::setReason()
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ClientDetailType $clientDetail
     * @param \DHLExpressGlobalWS\StructType\RequestType $request
     * @param string $pickupDate
     * @param string $pickupCountry
     * @param string $dispatchConfirmationNumber
     * @param string $requestorName
     * @param string $reason
     */
    public function __construct(\DHLExpressGlobalWS\StructType\DocTypeRef_ClientDetailType $clientDetail = null, \DHLExpressGlobalWS\StructType\RequestType $request = null, $pickupDate = null, $pickupCountry = null, $dispatchConfirmationNumber = null, $requestorName = null, $reason = null)
    {
        $this
            ->setClientDetail($clientDetail)
            ->setRequest($request)
            ->setPickupDate($pickupDate)
            ->setPickupCountry($pickupCountry)
            ->setDispatchConfirmationNumber($dispatchConfirmationNumber)
            ->setRequestorName($requestorName)
            ->setReason($reason);
    }
    /**
     * Get ClientDetail value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ClientDetailType|null
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ClientDetailType $clientDetail
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public function setClientDetail(\DHLExpressGlobalWS\StructType\DocTypeRef_ClientDetailType $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get Request value
     * @return \DHLExpressGlobalWS\StructType\RequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \DHLExpressGlobalWS\StructType\RequestType $request
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public function setRequest(\DHLExpressGlobalWS\StructType\RequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get PickupCountry value
     * @return string|null
     */
    public function getPickupCountry()
    {
        return $this->PickupCountry;
    }
    /**
     * Set PickupCountry value
     * @param string $pickupCountry
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public function setPickupCountry($pickupCountry = null)
    {
        // validation for constraint: string
        if (!is_null($pickupCountry) && !is_string($pickupCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupCountry, true), gettype($pickupCountry)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($pickupCountry) && mb_strlen($pickupCountry) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($pickupCountry)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($pickupCountry) && mb_strlen($pickupCountry) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($pickupCountry)), __LINE__);
        }
        $this->PickupCountry = $pickupCountry;
        return $this;
    }
    /**
     * Get DispatchConfirmationNumber value
     * @return string|null
     */
    public function getDispatchConfirmationNumber()
    {
        return $this->DispatchConfirmationNumber;
    }
    /**
     * Set DispatchConfirmationNumber value
     * @param string $dispatchConfirmationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public function setDispatchConfirmationNumber($dispatchConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchConfirmationNumber) && !is_string($dispatchConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchConfirmationNumber, true), gettype($dispatchConfirmationNumber)), __LINE__);
        }
        $this->DispatchConfirmationNumber = $dispatchConfirmationNumber;
        return $this;
    }
    /**
     * Get RequestorName value
     * @return string|null
     */
    public function getRequestorName()
    {
        return $this->RequestorName;
    }
    /**
     * Set RequestorName value
     * @param string $requestorName
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public function setRequestorName($requestorName = null)
    {
        // validation for constraint: string
        if (!is_null($requestorName) && !is_string($requestorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorName, true), gettype($requestorName)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($requestorName) && mb_strlen($requestorName) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($requestorName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($requestorName) && mb_strlen($requestorName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($requestorName)), __LINE__);
        }
        $this->RequestorName = $requestorName;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($reason) && mb_strlen($reason) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($reason)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reason) && mb_strlen($reason) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DeleteRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
