<?php

namespace DHLExpressGlobalWS\EnumType;

/**
 * This class stands for _x0040_account EnumType
 * @subpackage Enumerations
 */
class _x0040_account
{
    /**
     * Constant for value 'PAYOR_ACCOUNT'
     * @return string 'PAYOR_ACCOUNT'
     */
    const VALUE_PAYOR_ACCOUNT = 'PAYOR_ACCOUNT';
    /**
     * Constant for value 'RATED_ACCOUNT'
     * @return string 'RATED_ACCOUNT'
     */
    const VALUE_RATED_ACCOUNT = 'RATED_ACCOUNT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAYOR_ACCOUNT
     * @uses self::VALUE_RATED_ACCOUNT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAYOR_ACCOUNT,
            self::VALUE_RATED_ACCOUNT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
