<?php

namespace DHLExpressGlobalWS\EnumType;

/**
 * This class stands for ExportReasonType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Export reason code (Permanent, Temporary,Return)
 * @subpackage Enumerations
 */
class ExportReasonType
{
    /**
     * Constant for value 'PERMANENT'
     * @return string 'PERMANENT'
     */
    const VALUE_PERMANENT = 'PERMANENT';
    /**
     * Constant for value 'TEMPORARY'
     * @return string 'TEMPORARY'
     */
    const VALUE_TEMPORARY = 'TEMPORARY';
    /**
     * Constant for value 'RETURN'
     * @return string 'RETURN'
     */
    const VALUE_RETURN = 'RETURN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERMANENT
     * @uses self::VALUE_TEMPORARY
     * @uses self::VALUE_RETURN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERMANENT,
            self::VALUE_TEMPORARY,
            self::VALUE_RETURN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
