<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherCharge StructType
 * Meta informations extracted from the WSDL
 * - documentation: Other Charge caption and its charge value
 * @subpackage Structs
 */
class OtherCharge extends AbstractStructBase
{
    /**
     * The Caption
     * Meta informations extracted from the WSDL
     * - documentation: Other Charges Caption
     * - base: xsd:string
     * @var string
     */
    public $Caption;
    /**
     * The ChargeValue
     * Meta informations extracted from the WSDL
     * - documentation: Charge value can be passed to print in this field
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 15
     * - whiteSpace: collapse
     * @var float
     */
    public $ChargeValue;
    /**
     * Constructor method for OtherCharge
     * @uses OtherCharge::setCaption()
     * @uses OtherCharge::setChargeValue()
     * @param string $caption
     * @param float $chargeValue
     */
    public function __construct($caption = null, $chargeValue = null)
    {
        $this
            ->setCaption($caption)
            ->setChargeValue($chargeValue);
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \DHLExpressGlobalWS\StructType\OtherCharge
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($caption, true), gettype($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ChargeValue value
     * @return float|null
     */
    public function getChargeValue()
    {
        return $this->ChargeValue;
    }
    /**
     * Set ChargeValue value
     * @param float $chargeValue
     * @return \DHLExpressGlobalWS\StructType\OtherCharge
     */
    public function setChargeValue($chargeValue = null)
    {
        // validation for constraint: float
        if (!is_null($chargeValue) && !(is_float($chargeValue) || is_numeric($chargeValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeValue, true), gettype($chargeValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($chargeValue) && mb_strlen(mb_substr($chargeValue, mb_strpos($chargeValue, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($chargeValue, true), mb_strlen(mb_substr($chargeValue, mb_strpos($chargeValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($chargeValue) && mb_strlen(preg_replace('/(\D)/', '', $chargeValue)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($chargeValue, true), mb_strlen(preg_replace('/(\D)/', '', $chargeValue))), __LINE__);
        }
        $this->ChargeValue = $chargeValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\OtherCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
