<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemType StructType
 * @subpackage Structs
 */
class ItemType extends AbstractStructBase
{
    /**
     * The GoodsCharacteristics
     * Meta informations extracted from the WSDL
     * - documentation: Additional goods characteristics associated to the line item.
     * - minOccurs: 1
     * @var \DHLExpressGlobalWS\StructType\GoodsCharacteristicsType
     */
    public $GoodsCharacteristics;
    /**
     * The ItemNumber
     * Meta informations extracted from the WSDL
     * - documentation: Line item number
     * - minOccurs: 0
     * @var int
     */
    public $ItemNumber;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Item name
     * - base: xsd:string
     * - maxLength: 512
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $Description;
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - documentation: Item full description
     * - base: xsd:string
     * - maxLength: 255
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $Remark;
    /**
     * The ManufacturingCountryCode
     * Meta informations extracted from the WSDL
     * - documentation: Item country code of manufacture
     * - base: xsd:token
     * - maxLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ManufacturingCountryCode;
    /**
     * The SKUPartNumber
     * Meta informations extracted from the WSDL
     * - documentation: Item part number
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SKUPartNumber;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Quantity;
    /**
     * The QuantityType
     * Meta informations extracted from the WSDL
     * - documentation: Item quantity unit of measure: PRT=Part/Article, BOX=Box
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $QuantityType;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - documentation: Product unit price
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $UnitPrice;
    /**
     * The UnitPriceCurrencyCode
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $UnitPriceCurrencyCode;
    /**
     * The CustomsValue
     * Meta informations extracted from the WSDL
     * - documentation: Customs value
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $CustomsValue;
    /**
     * The CustomsValueCurrencyCode
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $CustomsValueCurrencyCode;
    /**
     * The HarmonizedSystemCode
     * Meta informations extracted from the WSDL
     * - documentation: Item 10-char HS code
     * - base: xsd:string
     * - maxLength: 18
     * - minOccurs: 0
     * @var string
     */
    public $HarmonizedSystemCode;
    /**
     * The ItemWeight
     * Meta informations extracted from the WSDL
     * - documentation: Item weight
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $ItemWeight;
    /**
     * The ItemWeightUnitofMeasurement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemWeightUnitofMeasurement;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - documentation: Item category
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - documentation: Item brand name
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The AdditionalQuantityDefinitions
     * Meta informations extracted from the WSDL
     * - documentation: Additional quantity and UOM types associated to the line item.
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\AdditionalQuantityDefinitionsType
     */
    public $AdditionalQuantityDefinitions;
    /**
     * Constructor method for ItemType
     * @uses ItemType::setGoodsCharacteristics()
     * @uses ItemType::setItemNumber()
     * @uses ItemType::setDescription()
     * @uses ItemType::setRemark()
     * @uses ItemType::setManufacturingCountryCode()
     * @uses ItemType::setSKUPartNumber()
     * @uses ItemType::setQuantity()
     * @uses ItemType::setQuantityType()
     * @uses ItemType::setUnitPrice()
     * @uses ItemType::setUnitPriceCurrencyCode()
     * @uses ItemType::setCustomsValue()
     * @uses ItemType::setCustomsValueCurrencyCode()
     * @uses ItemType::setHarmonizedSystemCode()
     * @uses ItemType::setItemWeight()
     * @uses ItemType::setItemWeightUnitofMeasurement()
     * @uses ItemType::setCategory()
     * @uses ItemType::setBrand()
     * @uses ItemType::setAdditionalQuantityDefinitions()
     * @param \DHLExpressGlobalWS\StructType\GoodsCharacteristicsType $goodsCharacteristics
     * @param int $itemNumber
     * @param string $description
     * @param string $remark
     * @param string $manufacturingCountryCode
     * @param string $sKUPartNumber
     * @param float $quantity
     * @param string $quantityType
     * @param float $unitPrice
     * @param string $unitPriceCurrencyCode
     * @param float $customsValue
     * @param string $customsValueCurrencyCode
     * @param string $harmonizedSystemCode
     * @param float $itemWeight
     * @param string $itemWeightUnitofMeasurement
     * @param string $category
     * @param string $brand
     * @param \DHLExpressGlobalWS\StructType\AdditionalQuantityDefinitionsType $additionalQuantityDefinitions
     */
    public function __construct(\DHLExpressGlobalWS\StructType\GoodsCharacteristicsType $goodsCharacteristics = null, $itemNumber = null, $description = null, $remark = null, $manufacturingCountryCode = null, $sKUPartNumber = null, $quantity = null, $quantityType = null, $unitPrice = null, $unitPriceCurrencyCode = null, $customsValue = null, $customsValueCurrencyCode = null, $harmonizedSystemCode = null, $itemWeight = null, $itemWeightUnitofMeasurement = null, $category = null, $brand = null, \DHLExpressGlobalWS\StructType\AdditionalQuantityDefinitionsType $additionalQuantityDefinitions = null)
    {
        $this
            ->setGoodsCharacteristics($goodsCharacteristics)
            ->setItemNumber($itemNumber)
            ->setDescription($description)
            ->setRemark($remark)
            ->setManufacturingCountryCode($manufacturingCountryCode)
            ->setSKUPartNumber($sKUPartNumber)
            ->setQuantity($quantity)
            ->setQuantityType($quantityType)
            ->setUnitPrice($unitPrice)
            ->setUnitPriceCurrencyCode($unitPriceCurrencyCode)
            ->setCustomsValue($customsValue)
            ->setCustomsValueCurrencyCode($customsValueCurrencyCode)
            ->setHarmonizedSystemCode($harmonizedSystemCode)
            ->setItemWeight($itemWeight)
            ->setItemWeightUnitofMeasurement($itemWeightUnitofMeasurement)
            ->setCategory($category)
            ->setBrand($brand)
            ->setAdditionalQuantityDefinitions($additionalQuantityDefinitions);
    }
    /**
     * Get GoodsCharacteristics value
     * @return \DHLExpressGlobalWS\StructType\GoodsCharacteristicsType
     */
    public function getGoodsCharacteristics()
    {
        return $this->GoodsCharacteristics;
    }
    /**
     * Set GoodsCharacteristics value
     * @param \DHLExpressGlobalWS\StructType\GoodsCharacteristicsType $goodsCharacteristics
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setGoodsCharacteristics(\DHLExpressGlobalWS\StructType\GoodsCharacteristicsType $goodsCharacteristics = null)
    {
        $this->GoodsCharacteristics = $goodsCharacteristics;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return int|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param int $itemNumber
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !(is_int($itemNumber) || ctype_digit($itemNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(512)
        if (!is_null($description) && mb_strlen($description) > 512) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 512', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($remark) && mb_strlen($remark) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($remark)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($remark) && mb_strlen($remark) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get ManufacturingCountryCode value
     * @return string|null
     */
    public function getManufacturingCountryCode()
    {
        return $this->ManufacturingCountryCode;
    }
    /**
     * Set ManufacturingCountryCode value
     * @param string $manufacturingCountryCode
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setManufacturingCountryCode($manufacturingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturingCountryCode) && !is_string($manufacturingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturingCountryCode, true), gettype($manufacturingCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($manufacturingCountryCode) && mb_strlen($manufacturingCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($manufacturingCountryCode)), __LINE__);
        }
        $this->ManufacturingCountryCode = $manufacturingCountryCode;
        return $this;
    }
    /**
     * Get SKUPartNumber value
     * @return string|null
     */
    public function getSKUPartNumber()
    {
        return $this->SKUPartNumber;
    }
    /**
     * Set SKUPartNumber value
     * @param string $sKUPartNumber
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setSKUPartNumber($sKUPartNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sKUPartNumber) && !is_string($sKUPartNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sKUPartNumber, true), gettype($sKUPartNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($sKUPartNumber) && mb_strlen($sKUPartNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($sKUPartNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($sKUPartNumber) && mb_strlen($sKUPartNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($sKUPartNumber)), __LINE__);
        }
        $this->SKUPartNumber = $sKUPartNumber;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QuantityType value
     * @return string|null
     */
    public function getQuantityType()
    {
        return $this->QuantityType;
    }
    /**
     * Set QuantityType value
     * @param string $quantityType
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setQuantityType($quantityType = null)
    {
        // validation for constraint: string
        if (!is_null($quantityType) && !is_string($quantityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantityType, true), gettype($quantityType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($quantityType) && mb_strlen($quantityType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($quantityType)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($quantityType) && mb_strlen($quantityType) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($quantityType)), __LINE__);
        }
        $this->QuantityType = $quantityType;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($unitPrice) && mb_strlen(mb_substr($unitPrice, mb_strpos($unitPrice, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($unitPrice, true), mb_strlen(mb_substr($unitPrice, mb_strpos($unitPrice, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($unitPrice) && mb_strlen(preg_replace('/(\D)/', '', $unitPrice)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($unitPrice, true), mb_strlen(preg_replace('/(\D)/', '', $unitPrice))), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get UnitPriceCurrencyCode value
     * @return string|null
     */
    public function getUnitPriceCurrencyCode()
    {
        return $this->UnitPriceCurrencyCode;
    }
    /**
     * Set UnitPriceCurrencyCode value
     * @param string $unitPriceCurrencyCode
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setUnitPriceCurrencyCode($unitPriceCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitPriceCurrencyCode) && !is_string($unitPriceCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPriceCurrencyCode, true), gettype($unitPriceCurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($unitPriceCurrencyCode) && mb_strlen($unitPriceCurrencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($unitPriceCurrencyCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($unitPriceCurrencyCode) && mb_strlen($unitPriceCurrencyCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($unitPriceCurrencyCode)), __LINE__);
        }
        $this->UnitPriceCurrencyCode = $unitPriceCurrencyCode;
        return $this;
    }
    /**
     * Get CustomsValue value
     * @return float|null
     */
    public function getCustomsValue()
    {
        return $this->CustomsValue;
    }
    /**
     * Set CustomsValue value
     * @param float $customsValue
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setCustomsValue($customsValue = null)
    {
        // validation for constraint: float
        if (!is_null($customsValue) && !(is_float($customsValue) || is_numeric($customsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customsValue, true), gettype($customsValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($customsValue) && mb_strlen(mb_substr($customsValue, mb_strpos($customsValue, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($customsValue, true), mb_strlen(mb_substr($customsValue, mb_strpos($customsValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($customsValue) && mb_strlen(preg_replace('/(\D)/', '', $customsValue)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($customsValue, true), mb_strlen(preg_replace('/(\D)/', '', $customsValue))), __LINE__);
        }
        $this->CustomsValue = $customsValue;
        return $this;
    }
    /**
     * Get CustomsValueCurrencyCode value
     * @return string|null
     */
    public function getCustomsValueCurrencyCode()
    {
        return $this->CustomsValueCurrencyCode;
    }
    /**
     * Set CustomsValueCurrencyCode value
     * @param string $customsValueCurrencyCode
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setCustomsValueCurrencyCode($customsValueCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($customsValueCurrencyCode) && !is_string($customsValueCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsValueCurrencyCode, true), gettype($customsValueCurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($customsValueCurrencyCode) && mb_strlen($customsValueCurrencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($customsValueCurrencyCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($customsValueCurrencyCode) && mb_strlen($customsValueCurrencyCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($customsValueCurrencyCode)), __LINE__);
        }
        $this->CustomsValueCurrencyCode = $customsValueCurrencyCode;
        return $this;
    }
    /**
     * Get HarmonizedSystemCode value
     * @return string|null
     */
    public function getHarmonizedSystemCode()
    {
        return $this->HarmonizedSystemCode;
    }
    /**
     * Set HarmonizedSystemCode value
     * @param string $harmonizedSystemCode
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setHarmonizedSystemCode($harmonizedSystemCode = null)
    {
        // validation for constraint: string
        if (!is_null($harmonizedSystemCode) && !is_string($harmonizedSystemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($harmonizedSystemCode, true), gettype($harmonizedSystemCode)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($harmonizedSystemCode) && mb_strlen($harmonizedSystemCode) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($harmonizedSystemCode)), __LINE__);
        }
        $this->HarmonizedSystemCode = $harmonizedSystemCode;
        return $this;
    }
    /**
     * Get ItemWeight value
     * @return float|null
     */
    public function getItemWeight()
    {
        return $this->ItemWeight;
    }
    /**
     * Set ItemWeight value
     * @param float $itemWeight
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setItemWeight($itemWeight = null)
    {
        // validation for constraint: float
        if (!is_null($itemWeight) && !(is_float($itemWeight) || is_numeric($itemWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemWeight, true), gettype($itemWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($itemWeight) && mb_strlen(mb_substr($itemWeight, mb_strpos($itemWeight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($itemWeight, true), mb_strlen(mb_substr($itemWeight, mb_strpos($itemWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($itemWeight) && mb_strlen(preg_replace('/(\D)/', '', $itemWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($itemWeight, true), mb_strlen(preg_replace('/(\D)/', '', $itemWeight))), __LINE__);
        }
        $this->ItemWeight = $itemWeight;
        return $this;
    }
    /**
     * Get ItemWeightUnitofMeasurement value
     * @return string|null
     */
    public function getItemWeightUnitofMeasurement()
    {
        return $this->ItemWeightUnitofMeasurement;
    }
    /**
     * Set ItemWeightUnitofMeasurement value
     * @uses \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemWeightUnitofMeasurement
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setItemWeightUnitofMeasurement($itemWeightUnitofMeasurement = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::valueIsValid($itemWeightUnitofMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2', is_array($itemWeightUnitofMeasurement) ? implode(', ', $itemWeightUnitofMeasurement) : var_export($itemWeightUnitofMeasurement, true), implode(', ', \DHLExpressGlobalWS\EnumType\UnitOfMeasurement2::getValidValues())), __LINE__);
        }
        $this->ItemWeightUnitofMeasurement = $itemWeightUnitofMeasurement;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($category) && mb_strlen($category) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($brand) && mb_strlen($brand) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get AdditionalQuantityDefinitions value
     * @return \DHLExpressGlobalWS\StructType\AdditionalQuantityDefinitionsType|null
     */
    public function getAdditionalQuantityDefinitions()
    {
        return $this->AdditionalQuantityDefinitions;
    }
    /**
     * Set AdditionalQuantityDefinitions value
     * @param \DHLExpressGlobalWS\StructType\AdditionalQuantityDefinitionsType $additionalQuantityDefinitions
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public function setAdditionalQuantityDefinitions(\DHLExpressGlobalWS\StructType\AdditionalQuantityDefinitionsType $additionalQuantityDefinitions = null)
    {
        $this->AdditionalQuantityDefinitions = $additionalQuantityDefinitions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\ItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
