<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BespokeLabelData StructType
 * @subpackage Structs
 */
class BespokeLabelData extends AbstractStructBase
{
    /**
     * The LabelBarcodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\LabelBarcodes
     */
    public $LabelBarcodes;
    /**
     * The LabelTextEntries
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\LabelTextEntries
     */
    public $LabelTextEntries;
    /**
     * The LabelDescription
     * Meta informations extracted from the WSDL
     * - documentation: Customer additional information Description
     * - base: xsd:token
     * - maxLength: 80
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $LabelDescription;
    /**
     * Constructor method for BespokeLabelData
     * @uses BespokeLabelData::setLabelBarcodes()
     * @uses BespokeLabelData::setLabelTextEntries()
     * @uses BespokeLabelData::setLabelDescription()
     * @param \DHLExpressGlobalWS\StructType\LabelBarcodes $labelBarcodes
     * @param \DHLExpressGlobalWS\StructType\LabelTextEntries $labelTextEntries
     * @param string $labelDescription
     */
    public function __construct(\DHLExpressGlobalWS\StructType\LabelBarcodes $labelBarcodes = null, \DHLExpressGlobalWS\StructType\LabelTextEntries $labelTextEntries = null, $labelDescription = null)
    {
        $this
            ->setLabelBarcodes($labelBarcodes)
            ->setLabelTextEntries($labelTextEntries)
            ->setLabelDescription($labelDescription);
    }
    /**
     * Get LabelBarcodes value
     * @return \DHLExpressGlobalWS\StructType\LabelBarcodes|null
     */
    public function getLabelBarcodes()
    {
        return $this->LabelBarcodes;
    }
    /**
     * Set LabelBarcodes value
     * @param \DHLExpressGlobalWS\StructType\LabelBarcodes $labelBarcodes
     * @return \DHLExpressGlobalWS\StructType\BespokeLabelData
     */
    public function setLabelBarcodes(\DHLExpressGlobalWS\StructType\LabelBarcodes $labelBarcodes = null)
    {
        $this->LabelBarcodes = $labelBarcodes;
        return $this;
    }
    /**
     * Get LabelTextEntries value
     * @return \DHLExpressGlobalWS\StructType\LabelTextEntries|null
     */
    public function getLabelTextEntries()
    {
        return $this->LabelTextEntries;
    }
    /**
     * Set LabelTextEntries value
     * @param \DHLExpressGlobalWS\StructType\LabelTextEntries $labelTextEntries
     * @return \DHLExpressGlobalWS\StructType\BespokeLabelData
     */
    public function setLabelTextEntries(\DHLExpressGlobalWS\StructType\LabelTextEntries $labelTextEntries = null)
    {
        $this->LabelTextEntries = $labelTextEntries;
        return $this;
    }
    /**
     * Get LabelDescription value
     * @return string|null
     */
    public function getLabelDescription()
    {
        return $this->LabelDescription;
    }
    /**
     * Set LabelDescription value
     * @param string $labelDescription
     * @return \DHLExpressGlobalWS\StructType\BespokeLabelData
     */
    public function setLabelDescription($labelDescription = null)
    {
        // validation for constraint: string
        if (!is_null($labelDescription) && !is_string($labelDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelDescription, true), gettype($labelDescription)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($labelDescription) && mb_strlen($labelDescription) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($labelDescription)), __LINE__);
        }
        $this->LabelDescription = $labelDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\BespokeLabelData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
