<?php

namespace DHLExpressGlobalWS\EnumType;

/**
 * This class stands for ShipmentPaymentType2 EnumType
 * Meta informations extracted from the WSDL
 * - documentation: S=Bill-To Shipper, R=Bill-To Receiver, T=Bill-To Third Party
 * @subpackage Enumerations
 */
class ShipmentPaymentType2
{
    /**
     * Constant for value 'S'
     * @return string 'S'
     */
    const VALUE_S = 'S';
    /**
     * Constant for value 'R'
     * @return string 'R'
     */
    const VALUE_R = 'R';
    /**
     * Constant for value 'T'
     * @return string 'T'
     */
    const VALUE_T = 'T';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_S
     * @uses self::VALUE_R
     * @uses self::VALUE_T
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_S,
            self::VALUE_R,
            self::VALUE_T,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
