<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentImage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Custom Clearance Document Image
 * @subpackage Structs
 */
class DocumentImage extends AbstractStructBase
{
    /**
     * The DocumentImageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentImageType;
    /**
     * The DocumentImage
     * @var \DHLExpressGlobalWS\StructType\DocumentImage
     */
    public $DocumentImage;
    /**
     * The DocumentImageFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentImageFormat;
    /**
     * Constructor method for DocumentImage
     * @uses DocumentImage::setDocumentImageType()
     * @uses DocumentImage::setDocumentImage()
     * @uses DocumentImage::setDocumentImageFormat()
     * @param string $documentImageType
     * @param \DHLExpressGlobalWS\StructType\DocumentImage $documentImage
     * @param string $documentImageFormat
     */
    public function __construct($documentImageType = null, \DHLExpressGlobalWS\StructType\DocumentImage $documentImage = null, $documentImageFormat = null)
    {
        $this
            ->setDocumentImageType($documentImageType)
            ->setDocumentImage($documentImage)
            ->setDocumentImageFormat($documentImageFormat);
    }
    /**
     * Get DocumentImageType value
     * @return string|null
     */
    public function getDocumentImageType()
    {
        return $this->DocumentImageType;
    }
    /**
     * Set DocumentImageType value
     * @uses \DHLExpressGlobalWS\EnumType\DocumentImageType::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\DocumentImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentImageType
     * @return \DHLExpressGlobalWS\StructType\DocumentImage
     */
    public function setDocumentImageType($documentImageType = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\DocumentImageType::valueIsValid($documentImageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\DocumentImageType', is_array($documentImageType) ? implode(', ', $documentImageType) : var_export($documentImageType, true), implode(', ', \DHLExpressGlobalWS\EnumType\DocumentImageType::getValidValues())), __LINE__);
        }
        $this->DocumentImageType = $documentImageType;
        return $this;
    }
    /**
     * Get DocumentImage value
     * @return \DHLExpressGlobalWS\StructType\DocumentImage|null
     */
    public function getDocumentImage()
    {
        return $this->DocumentImage;
    }
    /**
     * Set DocumentImage value
     * @param \DHLExpressGlobalWS\StructType\DocumentImage $documentImage
     * @return \DHLExpressGlobalWS\StructType\DocumentImage
     */
    public function setDocumentImage(\DHLExpressGlobalWS\StructType\DocumentImage $documentImage = null)
    {
        $this->DocumentImage = $documentImage;
        return $this;
    }
    /**
     * Get DocumentImageFormat value
     * @return string|null
     */
    public function getDocumentImageFormat()
    {
        return $this->DocumentImageFormat;
    }
    /**
     * Set DocumentImageFormat value
     * @uses \DHLExpressGlobalWS\EnumType\DocumentImageFormat::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\DocumentImageFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentImageFormat
     * @return \DHLExpressGlobalWS\StructType\DocumentImage
     */
    public function setDocumentImageFormat($documentImageFormat = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\DocumentImageFormat::valueIsValid($documentImageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\DocumentImageFormat', is_array($documentImageFormat) ? implode(', ', $documentImageFormat) : var_export($documentImageFormat, true), implode(', ', \DHLExpressGlobalWS\EnumType\DocumentImageFormat::getValidValues())), __LINE__);
        }
        $this->DocumentImageFormat = $documentImageFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocumentImage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
