<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_TotalNetType StructType
 * @subpackage Structs
 */
class DocTypeRef_TotalNetType extends AbstractStructBase
{
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the currency of the rate
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the rate price.
     * @var string
     */
    public $Amount;
    /**
     * Constructor method for docTypeRef_TotalNetType
     * @uses DocTypeRef_TotalNetType::setCurrency()
     * @uses DocTypeRef_TotalNetType::setAmount()
     * @param string $currency
     * @param string $amount
     */
    public function __construct($currency = null, $amount = null)
    {
        $this
            ->setCurrency($currency)
            ->setAmount($amount);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
