<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ShipmentInfoType StructType
 * @subpackage Structs
 */
class DocTypeRef_ShipmentInfoType extends AbstractStructBase
{
    /**
     * The DropOffType
     * @var string
     */
    public $DropOffType;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: Optional DHL service - global code
     * @var string
     */
    public $ServiceType;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $Account;
    /**
     * The Billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\Billing
     */
    public $Billing;
    /**
     * The SpecialServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\Services
     */
    public $SpecialServices;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $Currency;
    /**
     * The UnitOfMeasurement
     * Meta informations extracted from the WSDL
     * - documentation: SI=the preferred system of weights and measures for Italian trade and commerce; SU=the preferred system of weights and measures for U.S. trade and commerce; Weight unit: if Type is SI it can be KG (kilograms), if Type is SU it can be
     * LB (pounds). Dimention unit: if Type is SI it can be CM, if Type is SU it can be IN (inch)
     * @var string
     */
    public $UnitOfMeasurement;
    /**
     * The ShipmentIdentificationNumber
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The UseOwnShipmentIdentificationNumber
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $UseOwnShipmentIdentificationNumber;
    /**
     * The PackagesCount
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PackagesCount;
    /**
     * The SendPackage
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $SendPackage;
    /**
     * The LabelType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelType;
    /**
     * The LabelTemplate
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $LabelTemplate;
    /**
     * The ArchiveLabelTemplate
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $ArchiveLabelTemplate;
    /**
     * The PaperlessTradeEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PaperlessTradeEnabled;
    /**
     * The PaperlessTradeImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaperlessTradeImage;
    /**
     * Constructor method for docTypeRef_ShipmentInfoType
     * @uses DocTypeRef_ShipmentInfoType::setDropOffType()
     * @uses DocTypeRef_ShipmentInfoType::setServiceType()
     * @uses DocTypeRef_ShipmentInfoType::setAccount()
     * @uses DocTypeRef_ShipmentInfoType::setBilling()
     * @uses DocTypeRef_ShipmentInfoType::setSpecialServices()
     * @uses DocTypeRef_ShipmentInfoType::setCurrency()
     * @uses DocTypeRef_ShipmentInfoType::setUnitOfMeasurement()
     * @uses DocTypeRef_ShipmentInfoType::setShipmentIdentificationNumber()
     * @uses DocTypeRef_ShipmentInfoType::setUseOwnShipmentIdentificationNumber()
     * @uses DocTypeRef_ShipmentInfoType::setPackagesCount()
     * @uses DocTypeRef_ShipmentInfoType::setSendPackage()
     * @uses DocTypeRef_ShipmentInfoType::setLabelType()
     * @uses DocTypeRef_ShipmentInfoType::setLabelTemplate()
     * @uses DocTypeRef_ShipmentInfoType::setArchiveLabelTemplate()
     * @uses DocTypeRef_ShipmentInfoType::setPaperlessTradeEnabled()
     * @uses DocTypeRef_ShipmentInfoType::setPaperlessTradeImage()
     * @param string $dropOffType
     * @param string $serviceType
     * @param string $account
     * @param \DHLExpressGlobalWS\StructType\Billing $billing
     * @param \DHLExpressGlobalWS\StructType\Services $specialServices
     * @param string $currency
     * @param string $unitOfMeasurement
     * @param string $shipmentIdentificationNumber
     * @param string $useOwnShipmentIdentificationNumber
     * @param string $packagesCount
     * @param string $sendPackage
     * @param string $labelType
     * @param string $labelTemplate
     * @param string $archiveLabelTemplate
     * @param bool $paperlessTradeEnabled
     * @param string $paperlessTradeImage
     */
    public function __construct($dropOffType = null, $serviceType = null, $account = null, \DHLExpressGlobalWS\StructType\Billing $billing = null, \DHLExpressGlobalWS\StructType\Services $specialServices = null, $currency = null, $unitOfMeasurement = null, $shipmentIdentificationNumber = null, $useOwnShipmentIdentificationNumber = 'N', $packagesCount = null, $sendPackage = null, $labelType = null, $labelTemplate = null, $archiveLabelTemplate = null, $paperlessTradeEnabled = null, $paperlessTradeImage = null)
    {
        $this
            ->setDropOffType($dropOffType)
            ->setServiceType($serviceType)
            ->setAccount($account)
            ->setBilling($billing)
            ->setSpecialServices($specialServices)
            ->setCurrency($currency)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setUseOwnShipmentIdentificationNumber($useOwnShipmentIdentificationNumber)
            ->setPackagesCount($packagesCount)
            ->setSendPackage($sendPackage)
            ->setLabelType($labelType)
            ->setLabelTemplate($labelTemplate)
            ->setArchiveLabelTemplate($archiveLabelTemplate)
            ->setPaperlessTradeEnabled($paperlessTradeEnabled)
            ->setPaperlessTradeImage($paperlessTradeImage);
    }
    /**
     * Get DropOffType value
     * @return string|null
     */
    public function getDropOffType()
    {
        return $this->DropOffType;
    }
    /**
     * Set DropOffType value
     * @uses \DHLExpressGlobalWS\EnumType\DropOffType::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\DropOffType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dropOffType
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setDropOffType($dropOffType = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\DropOffType::valueIsValid($dropOffType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\DropOffType', is_array($dropOffType) ? implode(', ', $dropOffType) : var_export($dropOffType, true), implode(', ', \DHLExpressGlobalWS\EnumType\DropOffType::getValidValues())), __LINE__);
        }
        $this->DropOffType = $dropOffType;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($account) && mb_strlen($account) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($account)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($account) && mb_strlen($account) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Billing value
     * @return \DHLExpressGlobalWS\StructType\Billing|null
     */
    public function getBilling()
    {
        return $this->Billing;
    }
    /**
     * Set Billing value
     * @param \DHLExpressGlobalWS\StructType\Billing $billing
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setBilling(\DHLExpressGlobalWS\StructType\Billing $billing = null)
    {
        $this->Billing = $billing;
        return $this;
    }
    /**
     * Get SpecialServices value
     * @return \DHLExpressGlobalWS\StructType\Services|null
     */
    public function getSpecialServices()
    {
        return $this->SpecialServices;
    }
    /**
     * Set SpecialServices value
     * @param \DHLExpressGlobalWS\StructType\Services $specialServices
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setSpecialServices(\DHLExpressGlobalWS\StructType\Services $specialServices = null)
    {
        $this->SpecialServices = $specialServices;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($currency) && mb_strlen($currency) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($currency)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($currency) && mb_strlen($currency) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return string|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @uses \DHLExpressGlobalWS\EnumType\UnitOfMeasurement::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\UnitOfMeasurement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unitOfMeasurement
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setUnitOfMeasurement($unitOfMeasurement = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\UnitOfMeasurement::valueIsValid($unitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\UnitOfMeasurement', is_array($unitOfMeasurement) ? implode(', ', $unitOfMeasurement) : var_export($unitOfMeasurement, true), implode(', ', \DHLExpressGlobalWS\EnumType\UnitOfMeasurement::getValidValues())), __LINE__);
        }
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get UseOwnShipmentIdentificationNumber value
     * @return string|null
     */
    public function getUseOwnShipmentIdentificationNumber()
    {
        return $this->UseOwnShipmentIdentificationNumber;
    }
    /**
     * Set UseOwnShipmentIdentificationNumber value
     * @uses \DHLExpressGlobalWS\EnumType\UseOwnShipmentIdentificationNumber::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\UseOwnShipmentIdentificationNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useOwnShipmentIdentificationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setUseOwnShipmentIdentificationNumber($useOwnShipmentIdentificationNumber = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\UseOwnShipmentIdentificationNumber::valueIsValid($useOwnShipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\UseOwnShipmentIdentificationNumber', is_array($useOwnShipmentIdentificationNumber) ? implode(', ', $useOwnShipmentIdentificationNumber) : var_export($useOwnShipmentIdentificationNumber, true), implode(', ', \DHLExpressGlobalWS\EnumType\UseOwnShipmentIdentificationNumber::getValidValues())), __LINE__);
        }
        $this->UseOwnShipmentIdentificationNumber = $useOwnShipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get PackagesCount value
     * @return string|null
     */
    public function getPackagesCount()
    {
        return $this->PackagesCount;
    }
    /**
     * Set PackagesCount value
     * @param string $packagesCount
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setPackagesCount($packagesCount = null)
    {
        // validation for constraint: string
        if (!is_null($packagesCount) && !is_string($packagesCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagesCount, true), gettype($packagesCount)), __LINE__);
        }
        $this->PackagesCount = $packagesCount;
        return $this;
    }
    /**
     * Get SendPackage value
     * @return string|null
     */
    public function getSendPackage()
    {
        return $this->SendPackage;
    }
    /**
     * Set SendPackage value
     * @param string $sendPackage
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setSendPackage($sendPackage = null)
    {
        // validation for constraint: string
        if (!is_null($sendPackage) && !is_string($sendPackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendPackage, true), gettype($sendPackage)), __LINE__);
        }
        $this->SendPackage = $sendPackage;
        return $this;
    }
    /**
     * Get LabelType value
     * @return string|null
     */
    public function getLabelType()
    {
        return $this->LabelType;
    }
    /**
     * Set LabelType value
     * @uses \DHLExpressGlobalWS\EnumType\LabelType::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\LabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelType
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\LabelType::valueIsValid($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\LabelType', is_array($labelType) ? implode(', ', $labelType) : var_export($labelType, true), implode(', ', \DHLExpressGlobalWS\EnumType\LabelType::getValidValues())), __LINE__);
        }
        $this->LabelType = $labelType;
        return $this;
    }
    /**
     * Get LabelTemplate value
     * @return string|null
     */
    public function getLabelTemplate()
    {
        return $this->LabelTemplate;
    }
    /**
     * Set LabelTemplate value
     * @param string $labelTemplate
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setLabelTemplate($labelTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($labelTemplate) && !is_string($labelTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelTemplate, true), gettype($labelTemplate)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($labelTemplate) && mb_strlen($labelTemplate) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($labelTemplate)), __LINE__);
        }
        $this->LabelTemplate = $labelTemplate;
        return $this;
    }
    /**
     * Get ArchiveLabelTemplate value
     * @return string|null
     */
    public function getArchiveLabelTemplate()
    {
        return $this->ArchiveLabelTemplate;
    }
    /**
     * Set ArchiveLabelTemplate value
     * @param string $archiveLabelTemplate
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setArchiveLabelTemplate($archiveLabelTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($archiveLabelTemplate) && !is_string($archiveLabelTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveLabelTemplate, true), gettype($archiveLabelTemplate)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($archiveLabelTemplate) && mb_strlen($archiveLabelTemplate) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($archiveLabelTemplate)), __LINE__);
        }
        $this->ArchiveLabelTemplate = $archiveLabelTemplate;
        return $this;
    }
    /**
     * Get PaperlessTradeEnabled value
     * @return bool|null
     */
    public function getPaperlessTradeEnabled()
    {
        return $this->PaperlessTradeEnabled;
    }
    /**
     * Set PaperlessTradeEnabled value
     * @param bool $paperlessTradeEnabled
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setPaperlessTradeEnabled($paperlessTradeEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($paperlessTradeEnabled) && !is_bool($paperlessTradeEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paperlessTradeEnabled, true), gettype($paperlessTradeEnabled)), __LINE__);
        }
        $this->PaperlessTradeEnabled = $paperlessTradeEnabled;
        return $this;
    }
    /**
     * Get PaperlessTradeImage value
     * @return string|null
     */
    public function getPaperlessTradeImage()
    {
        return $this->PaperlessTradeImage;
    }
    /**
     * Set PaperlessTradeImage value
     * @param string $paperlessTradeImage
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setPaperlessTradeImage($paperlessTradeImage = null)
    {
        // validation for constraint: string
        if (!is_null($paperlessTradeImage) && !is_string($paperlessTradeImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paperlessTradeImage, true), gettype($paperlessTradeImage)), __LINE__);
        }
        $this->PaperlessTradeImage = $paperlessTradeImage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
