<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ShipmentDetailType StructType
 * @subpackage Structs
 */
class DocTypeRef_ShipmentDetailType extends AbstractStructBase
{
    /**
     * The Notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2[]
     */
    public $Notification;
    /**
     * The PackagesResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesResultsType
     */
    public $PackagesResult;
    /**
     * The LabelImage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType[]
     */
    public $LabelImage;
    /**
     * The ShipmentIdentificationNumber
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 10
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The DispatchConfirmationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DispatchConfirmationNumber;
    /**
     * Constructor method for docTypeRef_ShipmentDetailType
     * @uses DocTypeRef_ShipmentDetailType::setNotification()
     * @uses DocTypeRef_ShipmentDetailType::setPackagesResult()
     * @uses DocTypeRef_ShipmentDetailType::setLabelImage()
     * @uses DocTypeRef_ShipmentDetailType::setShipmentIdentificationNumber()
     * @uses DocTypeRef_ShipmentDetailType::setDispatchConfirmationNumber()
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2[] $notification
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesResultsType $packagesResult
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType[] $labelImage
     * @param string $shipmentIdentificationNumber
     * @param string $dispatchConfirmationNumber
     */
    public function __construct(array $notification = array(), \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesResultsType $packagesResult = null, array $labelImage = array(), $shipmentIdentificationNumber = null, $dispatchConfirmationNumber = null)
    {
        $this
            ->setNotification($notification)
            ->setPackagesResult($packagesResult)
            ->setLabelImage($labelImage)
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setDispatchConfirmationNumber($dispatchConfirmationNumber);
    }
    /**
     * Get Notification value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2[]|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * This method is responsible for validating the values passed to the setNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationForArrayConstraintsFromSetNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ShipmentDetailTypeNotificationItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ShipmentDetailTypeNotificationItem instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2) {
                $invalidValues[] = is_object($docTypeRef_ShipmentDetailTypeNotificationItem) ? get_class($docTypeRef_ShipmentDetailTypeNotificationItem) : sprintf('%s(%s)', gettype($docTypeRef_ShipmentDetailTypeNotificationItem), var_export($docTypeRef_ShipmentDetailTypeNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notification property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notification value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2[] $notification
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setNotification(array $notification = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationArrayErrorMessage = self::validateNotificationForArrayConstraintsFromSetNotification($notification))) {
            throw new \InvalidArgumentException($notificationArrayErrorMessage, __LINE__);
        }
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Add item to Notification value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2 $item
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public function addToNotification(\DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2) {
            throw new \InvalidArgumentException(sprintf('The Notification property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notification[] = $item;
        return $this;
    }
    /**
     * Get PackagesResult value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesResultsType|null
     */
    public function getPackagesResult()
    {
        return $this->PackagesResult;
    }
    /**
     * Set PackagesResult value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_PackagesResultsType $packagesResult
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setPackagesResult(\DHLExpressGlobalWS\StructType\DocTypeRef_PackagesResultsType $packagesResult = null)
    {
        $this->PackagesResult = $packagesResult;
        return $this;
    }
    /**
     * Get LabelImage value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType[]|null
     */
    public function getLabelImage()
    {
        return $this->LabelImage;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelImageForArrayConstraintsFromSetLabelImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ShipmentDetailTypeLabelImageItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ShipmentDetailTypeLabelImageItem instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType) {
                $invalidValues[] = is_object($docTypeRef_ShipmentDetailTypeLabelImageItem) ? get_class($docTypeRef_ShipmentDetailTypeLabelImageItem) : sprintf('%s(%s)', gettype($docTypeRef_ShipmentDetailTypeLabelImageItem), var_export($docTypeRef_ShipmentDetailTypeLabelImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LabelImage property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LabelImage value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType[] $labelImage
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setLabelImage(array $labelImage = array())
    {
        // validation for constraint: array
        if ('' !== ($labelImageArrayErrorMessage = self::validateLabelImageForArrayConstraintsFromSetLabelImage($labelImage))) {
            throw new \InvalidArgumentException($labelImageArrayErrorMessage, __LINE__);
        }
        $this->LabelImage = $labelImage;
        return $this;
    }
    /**
     * Add item to LabelImage value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType $item
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public function addToLabelImage(\DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType) {
            throw new \InvalidArgumentException(sprintf('The LabelImage property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_LabelImageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LabelImage[] = $item;
        return $this;
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($shipmentIdentificationNumber) && mb_strlen($shipmentIdentificationNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($shipmentIdentificationNumber)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($shipmentIdentificationNumber) && mb_strlen($shipmentIdentificationNumber) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get DispatchConfirmationNumber value
     * @return string|null
     */
    public function getDispatchConfirmationNumber()
    {
        return $this->DispatchConfirmationNumber;
    }
    /**
     * Set DispatchConfirmationNumber value
     * @param string $dispatchConfirmationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setDispatchConfirmationNumber($dispatchConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchConfirmationNumber) && !is_string($dispatchConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchConfirmationNumber, true), gettype($dispatchConfirmationNumber)), __LINE__);
        }
        $this->DispatchConfirmationNumber = $dispatchConfirmationNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ShipmentDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
