<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ServiceType StructType
 * @subpackage Structs
 */
class DocTypeRef_ServiceType extends AbstractStructBase
{
    /**
     * The TotalNet
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType
     */
    public $TotalNet;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_ChargesType
     */
    public $Charges;
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_ItemsType
     */
    public $Items;
    /**
     * The DeliveryTime
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the date and time the package is tendered. Both the date and time portions of the string are expected to be used. The date should not be a past date or a date more than 10 days in the future. The time is the local time of
     * the shipment based on the shipper's time zone. The date component must be in the format: YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g.
     * 2006-06-26T17:00:00).
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTime;
    /**
     * The CutoffTime
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the cutoff date and time the package needs to be tendered to the shipper, in order to meet the estimated delivery time.The time is the local time of the shipment based on the shipper's time zone. The date component must be
     * in the format:YYYY-MM-DD; the time component must be in the format: HH:MM:SS using a 24 hour clock. The date and time parts are separated by the letter T (e.g. 2006-06-26T17:00:00).
     * - minOccurs: 0
     * @var string
     */
    public $CutoffTime;
    /**
     * The NextBusinessDayInd
     * Meta informations extracted from the WSDL
     * - documentation: This indicator demonstrates whether the pickup date is the next business day (Y) or the requested business day (N). If the requested ship date is beyond the cutoff for that business day (or it is requested on weekend), the indicator
     * will be set to Y. If it is on the same business day as requested, the value is set to N.
     * - minOccurs: 0
     * @var string
     */
    public $NextBusinessDayInd;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: The service type provided from the currier.
     * - base: xsd:token
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $type;
    /**
     * The account
     * Meta informations extracted from the WSDL
     * - documentation: The rate type of the charges for this package. Possible returned rate types are: PAYOR_ACCOUNT, RATED_ACCOUNT.
     * @var string
     */
    public $account;
    /**
     * Constructor method for docTypeRef_ServiceType
     * @uses DocTypeRef_ServiceType::setTotalNet()
     * @uses DocTypeRef_ServiceType::setCharges()
     * @uses DocTypeRef_ServiceType::setItems()
     * @uses DocTypeRef_ServiceType::setDeliveryTime()
     * @uses DocTypeRef_ServiceType::setCutoffTime()
     * @uses DocTypeRef_ServiceType::setNextBusinessDayInd()
     * @uses DocTypeRef_ServiceType::setType()
     * @uses DocTypeRef_ServiceType::setAccount()
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType $totalNet
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ChargesType $charges
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ItemsType $items
     * @param string $deliveryTime
     * @param string $cutoffTime
     * @param string $nextBusinessDayInd
     * @param string $type
     * @param string $account
     */
    public function __construct(\DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType $totalNet = null, \DHLExpressGlobalWS\StructType\DocTypeRef_ChargesType $charges = null, \DHLExpressGlobalWS\StructType\DocTypeRef_ItemsType $items = null, $deliveryTime = null, $cutoffTime = null, $nextBusinessDayInd = null, $type = null, $account = null)
    {
        $this
            ->setTotalNet($totalNet)
            ->setCharges($charges)
            ->setItems($items)
            ->setDeliveryTime($deliveryTime)
            ->setCutoffTime($cutoffTime)
            ->setNextBusinessDayInd($nextBusinessDayInd)
            ->setType($type)
            ->setAccount($account);
    }
    /**
     * Get TotalNet value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType|null
     */
    public function getTotalNet()
    {
        return $this->TotalNet;
    }
    /**
     * Set TotalNet value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType $totalNet
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setTotalNet(\DHLExpressGlobalWS\StructType\DocTypeRef_TotalNetType $totalNet = null)
    {
        $this->TotalNet = $totalNet;
        return $this;
    }
    /**
     * Get Charges value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargesType|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ChargesType $charges
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setCharges(\DHLExpressGlobalWS\StructType\DocTypeRef_ChargesType $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Get Items value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ItemsType|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ItemsType $items
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setItems(\DHLExpressGlobalWS\StructType\DocTypeRef_ItemsType $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get DeliveryTime value
     * @return string|null
     */
    public function getDeliveryTime()
    {
        return $this->DeliveryTime;
    }
    /**
     * Set DeliveryTime value
     * @param string $deliveryTime
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setDeliveryTime($deliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTime) && !is_string($deliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTime, true), gettype($deliveryTime)), __LINE__);
        }
        $this->DeliveryTime = $deliveryTime;
        return $this;
    }
    /**
     * Get CutoffTime value
     * @return string|null
     */
    public function getCutoffTime()
    {
        return $this->CutoffTime;
    }
    /**
     * Set CutoffTime value
     * @param string $cutoffTime
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setCutoffTime($cutoffTime = null)
    {
        // validation for constraint: string
        if (!is_null($cutoffTime) && !is_string($cutoffTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cutoffTime, true), gettype($cutoffTime)), __LINE__);
        }
        $this->CutoffTime = $cutoffTime;
        return $this;
    }
    /**
     * Get NextBusinessDayInd value
     * @return string|null
     */
    public function getNextBusinessDayInd()
    {
        return $this->NextBusinessDayInd;
    }
    /**
     * Set NextBusinessDayInd value
     * @uses \DHLExpressGlobalWS\EnumType\NextBusinessDayInd2::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\NextBusinessDayInd2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nextBusinessDayInd
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setNextBusinessDayInd($nextBusinessDayInd = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\NextBusinessDayInd2::valueIsValid($nextBusinessDayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\NextBusinessDayInd2', is_array($nextBusinessDayInd) ? implode(', ', $nextBusinessDayInd) : var_export($nextBusinessDayInd, true), implode(', ', \DHLExpressGlobalWS\EnumType\NextBusinessDayInd2::getValidValues())), __LINE__);
        }
        $this->NextBusinessDayInd = $nextBusinessDayInd;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($type) && mb_strlen($type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @uses \DHLExpressGlobalWS\EnumType\_x0040_account::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\_x0040_account::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $account
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public function setAccount($account = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\_x0040_account::valueIsValid($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\_x0040_account', is_array($account) ? implode(', ', $account) : var_export($account, true), implode(', ', \DHLExpressGlobalWS\EnumType\_x0040_account::getValidValues())), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
