<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RequestedPackagesType StructType
 * @subpackage Structs
 */
class DocTypeRef_RequestedPackagesType extends AbstractStructBase
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - base: xsd:integer
     * - maxInclusive: 99
     * - minInclusive: 1
     * - use: required
     * @var int
     */
    public $number;
    /**
     * The InsuredValue
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 15
     * - whiteSpace: collapse
     * @var float
     */
    public $InsuredValue;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 12
     * - whiteSpace: collapse
     * @var float
     */
    public $Weight;
    /**
     * The PieceIdentificationNumber
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PieceIdentificationNumber;
    /**
     * The UseOwnPieceIdentificationNumber
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $UseOwnPieceIdentificationNumber;
    /**
     * The PackageContentDescription
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 70
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PackageContentDescription;
    /**
     * The Dimensions
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_DimensionsType
     */
    public $Dimensions;
    /**
     * The CustomerReferences
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 50
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $CustomerReferences;
    /**
     * Constructor method for docTypeRef_RequestedPackagesType
     * @uses DocTypeRef_RequestedPackagesType::setNumber()
     * @uses DocTypeRef_RequestedPackagesType::setInsuredValue()
     * @uses DocTypeRef_RequestedPackagesType::setWeight()
     * @uses DocTypeRef_RequestedPackagesType::setPieceIdentificationNumber()
     * @uses DocTypeRef_RequestedPackagesType::setUseOwnPieceIdentificationNumber()
     * @uses DocTypeRef_RequestedPackagesType::setPackageContentDescription()
     * @uses DocTypeRef_RequestedPackagesType::setDimensions()
     * @uses DocTypeRef_RequestedPackagesType::setCustomerReferences()
     * @param int $number
     * @param float $insuredValue
     * @param float $weight
     * @param string $pieceIdentificationNumber
     * @param string $useOwnPieceIdentificationNumber
     * @param string $packageContentDescription
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_DimensionsType $dimensions
     * @param string $customerReferences
     */
    public function __construct($number = null, $insuredValue = null, $weight = null, $pieceIdentificationNumber = null, $useOwnPieceIdentificationNumber = 'N', $packageContentDescription = null, \DHLExpressGlobalWS\StructType\DocTypeRef_DimensionsType $dimensions = null, $customerReferences = null)
    {
        $this
            ->setNumber($number)
            ->setInsuredValue($insuredValue)
            ->setWeight($weight)
            ->setPieceIdentificationNumber($pieceIdentificationNumber)
            ->setUseOwnPieceIdentificationNumber($useOwnPieceIdentificationNumber)
            ->setPackageContentDescription($packageContentDescription)
            ->setDimensions($dimensions)
            ->setCustomerReferences($customerReferences);
    }
    /**
     * Get number value
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($number) && $number > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($number) && $number < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get InsuredValue value
     * @return float|null
     */
    public function getInsuredValue()
    {
        return $this->InsuredValue;
    }
    /**
     * Set InsuredValue value
     * @param float $insuredValue
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setInsuredValue($insuredValue = null)
    {
        // validation for constraint: float
        if (!is_null($insuredValue) && !(is_float($insuredValue) || is_numeric($insuredValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuredValue, true), gettype($insuredValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($insuredValue) && mb_strlen(mb_substr($insuredValue, mb_strpos($insuredValue, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($insuredValue, true), mb_strlen(mb_substr($insuredValue, mb_strpos($insuredValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($insuredValue) && mb_strlen(preg_replace('/(\D)/', '', $insuredValue)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($insuredValue, true), mb_strlen(preg_replace('/(\D)/', '', $insuredValue))), __LINE__);
        }
        $this->InsuredValue = $insuredValue;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($weight) && mb_strlen(mb_substr($weight, mb_strpos($weight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($weight, true), mb_strlen(mb_substr($weight, mb_strpos($weight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($weight) && mb_strlen(preg_replace('/(\D)/', '', $weight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($weight, true), mb_strlen(preg_replace('/(\D)/', '', $weight))), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get PieceIdentificationNumber value
     * @return string|null
     */
    public function getPieceIdentificationNumber()
    {
        return $this->PieceIdentificationNumber;
    }
    /**
     * Set PieceIdentificationNumber value
     * @param string $pieceIdentificationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setPieceIdentificationNumber($pieceIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pieceIdentificationNumber) && !is_string($pieceIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pieceIdentificationNumber, true), gettype($pieceIdentificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($pieceIdentificationNumber) && mb_strlen($pieceIdentificationNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($pieceIdentificationNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($pieceIdentificationNumber) && mb_strlen($pieceIdentificationNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($pieceIdentificationNumber)), __LINE__);
        }
        $this->PieceIdentificationNumber = $pieceIdentificationNumber;
        return $this;
    }
    /**
     * Get UseOwnPieceIdentificationNumber value
     * @return string|null
     */
    public function getUseOwnPieceIdentificationNumber()
    {
        return $this->UseOwnPieceIdentificationNumber;
    }
    /**
     * Set UseOwnPieceIdentificationNumber value
     * @uses \DHLExpressGlobalWS\EnumType\UseOwnPieceIdentificationNumber::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\UseOwnPieceIdentificationNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useOwnPieceIdentificationNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setUseOwnPieceIdentificationNumber($useOwnPieceIdentificationNumber = 'N')
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\UseOwnPieceIdentificationNumber::valueIsValid($useOwnPieceIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\UseOwnPieceIdentificationNumber', is_array($useOwnPieceIdentificationNumber) ? implode(', ', $useOwnPieceIdentificationNumber) : var_export($useOwnPieceIdentificationNumber, true), implode(', ', \DHLExpressGlobalWS\EnumType\UseOwnPieceIdentificationNumber::getValidValues())), __LINE__);
        }
        $this->UseOwnPieceIdentificationNumber = $useOwnPieceIdentificationNumber;
        return $this;
    }
    /**
     * Get PackageContentDescription value
     * @return string|null
     */
    public function getPackageContentDescription()
    {
        return $this->PackageContentDescription;
    }
    /**
     * Set PackageContentDescription value
     * @param string $packageContentDescription
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setPackageContentDescription($packageContentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($packageContentDescription) && !is_string($packageContentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageContentDescription, true), gettype($packageContentDescription)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($packageContentDescription) && mb_strlen($packageContentDescription) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($packageContentDescription)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageContentDescription) && mb_strlen($packageContentDescription) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageContentDescription)), __LINE__);
        }
        $this->PackageContentDescription = $packageContentDescription;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_DimensionsType|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_DimensionsType $dimensions
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setDimensions(\DHLExpressGlobalWS\StructType\DocTypeRef_DimensionsType $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get CustomerReferences value
     * @return string|null
     */
    public function getCustomerReferences()
    {
        return $this->CustomerReferences;
    }
    /**
     * Set CustomerReferences value
     * @param string $customerReferences
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public function setCustomerReferences($customerReferences = null)
    {
        // validation for constraint: string
        if (!is_null($customerReferences) && !is_string($customerReferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReferences, true), gettype($customerReferences)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($customerReferences) && mb_strlen($customerReferences) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($customerReferences)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerReferences) && mb_strlen($customerReferences) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerReferences)), __LINE__);
        }
        $this->CustomerReferences = $customerReferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_RequestedPackagesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
