<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ProviderType StructType
 * @subpackage Structs
 */
class DocTypeRef_ProviderType extends AbstractStructBase
{
    /**
     * The ServiceHeader
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\ServiceHeaderType
     */
    public $ServiceHeader;
    /**
     * The Notification
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType3
     */
    public $Notification;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType[]
     */
    public $Service;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $code;
    /**
     * Constructor method for docTypeRef_ProviderType
     * @uses DocTypeRef_ProviderType::setServiceHeader()
     * @uses DocTypeRef_ProviderType::setNotification()
     * @uses DocTypeRef_ProviderType::setService()
     * @uses DocTypeRef_ProviderType::setCode()
     * @param \DHLExpressGlobalWS\StructType\ServiceHeaderType $serviceHeader
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType3 $notification
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType[] $service
     * @param string $code
     */
    public function __construct(\DHLExpressGlobalWS\StructType\ServiceHeaderType $serviceHeader = null, \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType3 $notification = null, array $service = array(), $code = null)
    {
        $this
            ->setServiceHeader($serviceHeader)
            ->setNotification($notification)
            ->setService($service)
            ->setCode($code);
    }
    /**
     * Get ServiceHeader value
     * @return \DHLExpressGlobalWS\StructType\ServiceHeaderType|null
     */
    public function getServiceHeader()
    {
        return $this->ServiceHeader;
    }
    /**
     * Set ServiceHeader value
     * @param \DHLExpressGlobalWS\StructType\ServiceHeaderType $serviceHeader
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ProviderType
     */
    public function setServiceHeader(\DHLExpressGlobalWS\StructType\ServiceHeaderType $serviceHeader = null)
    {
        $this->ServiceHeader = $serviceHeader;
        return $this;
    }
    /**
     * Get Notification value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType3|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType3 $notification
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ProviderType
     */
    public function setNotification(\DHLExpressGlobalWS\StructType\DocTypeRef_NotificationType3 $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get Service value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ProviderTypeServiceItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ProviderTypeServiceItem instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType) {
                $invalidValues[] = is_object($docTypeRef_ProviderTypeServiceItem) ? get_class($docTypeRef_ProviderTypeServiceItem) : sprintf('%s(%s)', gettype($docTypeRef_ProviderTypeServiceItem), var_export($docTypeRef_ProviderTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType[] $service
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ProviderType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType $item
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ProviderType
     */
    public function addToService(\DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_ServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ProviderType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ProviderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
