<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ItemType StructType
 * @subpackage Structs
 */
class DocTypeRef_ItemType extends AbstractStructBase
{
    /**
     * The ItemNumber
     * @var int
     */
    public $ItemNumber;
    /**
     * The Charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 50
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType[]
     */
    public $Charge;
    /**
     * The Notification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \DHLExpressGlobalWS\StructType\Notification
     */
    public $Notification;
    /**
     * Constructor method for docTypeRef_ItemType
     * @uses DocTypeRef_ItemType::setItemNumber()
     * @uses DocTypeRef_ItemType::setCharge()
     * @uses DocTypeRef_ItemType::setNotification()
     * @param int $itemNumber
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType[] $charge
     * @param \DHLExpressGlobalWS\StructType\Notification $notification
     */
    public function __construct($itemNumber = null, array $charge = array(), \DHLExpressGlobalWS\StructType\Notification $notification = null)
    {
        $this
            ->setItemNumber($itemNumber)
            ->setCharge($charge)
            ->setNotification($notification);
    }
    /**
     * Get ItemNumber value
     * @return int|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param int $itemNumber
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ItemType
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !(is_int($itemNumber) || ctype_digit($itemNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get Charge value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * This method is responsible for validating the values passed to the setCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeForArrayConstraintsFromSetCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ItemTypeChargeItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ItemTypeChargeItem instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType) {
                $invalidValues[] = is_object($docTypeRef_ItemTypeChargeItem) ? get_class($docTypeRef_ItemTypeChargeItem) : sprintf('%s(%s)', gettype($docTypeRef_ItemTypeChargeItem), var_export($docTypeRef_ItemTypeChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charge property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType[] $charge
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ItemType
     */
    public function setCharge(array $charge = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeArrayErrorMessage = self::validateChargeForArrayConstraintsFromSetCharge($charge))) {
            throw new \InvalidArgumentException($chargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($charge) && count($charge) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($charge)), __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType $item
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ItemType
     */
    public function addToCharge(\DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of type \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->Charge) && count($this->Charge) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->Charge)), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Get Notification value
     * @return \DHLExpressGlobalWS\StructType\Notification|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \DHLExpressGlobalWS\StructType\Notification $notification
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ItemType
     */
    public function setNotification(\DHLExpressGlobalWS\StructType\Notification $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
