<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_InternationDetailType StructType
 * @subpackage Structs
 */
class DocTypeRef_InternationDetailType extends AbstractStructBase
{
    /**
     * The Commodities
     * @var \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public $Commodities;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * The ExportReference
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 40
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ExportReference;
    /**
     * Constructor method for docTypeRef_InternationDetailType
     * @uses DocTypeRef_InternationDetailType::setCommodities()
     * @uses DocTypeRef_InternationDetailType::setContent()
     * @uses DocTypeRef_InternationDetailType::setExportReference()
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType $commodities
     * @param string $content
     * @param string $exportReference
     */
    public function __construct(\DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType $commodities = null, $content = null, $exportReference = null)
    {
        $this
            ->setCommodities($commodities)
            ->setContent($content)
            ->setExportReference($exportReference);
    }
    /**
     * Get Commodities value
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType|null
     */
    public function getCommodities()
    {
        return $this->Commodities;
    }
    /**
     * Set Commodities value
     * @param \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType $commodities
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_InternationDetailType
     */
    public function setCommodities(\DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType $commodities = null)
    {
        $this->Commodities = $commodities;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @uses \DHLExpressGlobalWS\EnumType\Content::valueIsValid()
     * @uses \DHLExpressGlobalWS\EnumType\Content::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $content
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_InternationDetailType
     */
    public function setContent($content = null)
    {
        // validation for constraint: enumeration
        if (!\DHLExpressGlobalWS\EnumType\Content::valueIsValid($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \DHLExpressGlobalWS\EnumType\Content', is_array($content) ? implode(', ', $content) : var_export($content, true), implode(', ', \DHLExpressGlobalWS\EnumType\Content::getValidValues())), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get ExportReference value
     * @return string|null
     */
    public function getExportReference()
    {
        return $this->ExportReference;
    }
    /**
     * Set ExportReference value
     * @param string $exportReference
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_InternationDetailType
     */
    public function setExportReference($exportReference = null)
    {
        // validation for constraint: string
        if (!is_null($exportReference) && !is_string($exportReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportReference, true), gettype($exportReference)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($exportReference) && mb_strlen($exportReference) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($exportReference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($exportReference) && mb_strlen($exportReference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($exportReference)), __LINE__);
        }
        $this->ExportReference = $exportReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_InternationDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
