<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_CommoditiesType StructType
 * @subpackage Structs
 */
class DocTypeRef_CommoditiesType extends AbstractStructBase
{
    /**
     * The NumberOfPieces
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $NumberOfPieces;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $Description;
    /**
     * The CountryOfManufacture
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $CountryOfManufacture;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $Quantity;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $UnitPrice;
    /**
     * The CustomsValue
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 18
     * - whiteSpace: collapse
     * @var float
     */
    public $CustomsValue;
    /**
     * The USFilingTypeValue
     * Meta informations extracted from the WSDL
     * - documentation: USFilingTypeValue is a field meant for US export/import EEI Filing (ITN Number, FTR Number and AES4 Number
     * - base: xsd:string
     * - maxLength: 20
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $USFilingTypeValue;
    /**
     * Constructor method for docTypeRef_CommoditiesType
     * @uses DocTypeRef_CommoditiesType::setNumberOfPieces()
     * @uses DocTypeRef_CommoditiesType::setDescription()
     * @uses DocTypeRef_CommoditiesType::setCountryOfManufacture()
     * @uses DocTypeRef_CommoditiesType::setQuantity()
     * @uses DocTypeRef_CommoditiesType::setUnitPrice()
     * @uses DocTypeRef_CommoditiesType::setCustomsValue()
     * @uses DocTypeRef_CommoditiesType::setUSFilingTypeValue()
     * @param string $numberOfPieces
     * @param string $description
     * @param string $countryOfManufacture
     * @param string $quantity
     * @param string $unitPrice
     * @param float $customsValue
     * @param string $uSFilingTypeValue
     */
    public function __construct($numberOfPieces = null, $description = null, $countryOfManufacture = null, $quantity = null, $unitPrice = null, $customsValue = null, $uSFilingTypeValue = null)
    {
        $this
            ->setNumberOfPieces($numberOfPieces)
            ->setDescription($description)
            ->setCountryOfManufacture($countryOfManufacture)
            ->setQuantity($quantity)
            ->setUnitPrice($unitPrice)
            ->setCustomsValue($customsValue)
            ->setUSFilingTypeValue($uSFilingTypeValue);
    }
    /**
     * Get NumberOfPieces value
     * @return string|null
     */
    public function getNumberOfPieces()
    {
        return $this->NumberOfPieces;
    }
    /**
     * Set NumberOfPieces value
     * @param string $numberOfPieces
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public function setNumberOfPieces($numberOfPieces = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfPieces) && !is_string($numberOfPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOfPieces, true), gettype($numberOfPieces)), __LINE__);
        }
        $this->NumberOfPieces = $numberOfPieces;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($description) && mb_strlen($description) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CountryOfManufacture value
     * @return string|null
     */
    public function getCountryOfManufacture()
    {
        return $this->CountryOfManufacture;
    }
    /**
     * Set CountryOfManufacture value
     * @param string $countryOfManufacture
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public function setCountryOfManufacture($countryOfManufacture = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfManufacture) && !is_string($countryOfManufacture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfManufacture, true), gettype($countryOfManufacture)), __LINE__);
        }
        $this->CountryOfManufacture = $countryOfManufacture;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return string|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param string $unitPrice
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrice) && !is_string($unitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get CustomsValue value
     * @return float|null
     */
    public function getCustomsValue()
    {
        return $this->CustomsValue;
    }
    /**
     * Set CustomsValue value
     * @param float $customsValue
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public function setCustomsValue($customsValue = null)
    {
        // validation for constraint: float
        if (!is_null($customsValue) && !(is_float($customsValue) || is_numeric($customsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customsValue, true), gettype($customsValue)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($customsValue) && mb_strlen(mb_substr($customsValue, mb_strpos($customsValue, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($customsValue, true), mb_strlen(mb_substr($customsValue, mb_strpos($customsValue, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($customsValue) && mb_strlen(preg_replace('/(\D)/', '', $customsValue)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($customsValue, true), mb_strlen(preg_replace('/(\D)/', '', $customsValue))), __LINE__);
        }
        $this->CustomsValue = $customsValue;
        return $this;
    }
    /**
     * Get USFilingTypeValue value
     * @return string|null
     */
    public function getUSFilingTypeValue()
    {
        return $this->USFilingTypeValue;
    }
    /**
     * Set USFilingTypeValue value
     * @param string $uSFilingTypeValue
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public function setUSFilingTypeValue($uSFilingTypeValue = null)
    {
        // validation for constraint: string
        if (!is_null($uSFilingTypeValue) && !is_string($uSFilingTypeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSFilingTypeValue, true), gettype($uSFilingTypeValue)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($uSFilingTypeValue) && mb_strlen($uSFilingTypeValue) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($uSFilingTypeValue)), __LINE__);
        }
        $this->USFilingTypeValue = $uSFilingTypeValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_CommoditiesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
