<?php

namespace DHLExpressGlobalWS\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ChargeType StructType
 * @subpackage Structs
 */
class DocTypeRef_ChargeType extends AbstractStructBase
{
    /**
     * The ChargeCode
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The ChargeType
     * @var string
     */
    public $ChargeType;
    /**
     * The ChargeAmount
     * @var string
     */
    public $ChargeAmount;
    /**
     * The ChargeName
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeName;
    /**
     * The ChargeCurrencyCode
     * Meta informations extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCurrencyCode;
    /**
     * Constructor method for docTypeRef_ChargeType
     * @uses DocTypeRef_ChargeType::setChargeCode()
     * @uses DocTypeRef_ChargeType::setChargeType()
     * @uses DocTypeRef_ChargeType::setChargeAmount()
     * @uses DocTypeRef_ChargeType::setChargeName()
     * @uses DocTypeRef_ChargeType::setChargeCurrencyCode()
     * @param string $chargeCode
     * @param string $chargeType
     * @param string $chargeAmount
     * @param string $chargeName
     * @param string $chargeCurrencyCode
     */
    public function __construct($chargeCode = null, $chargeType = null, $chargeAmount = null, $chargeName = null, $chargeCurrencyCode = null)
    {
        $this
            ->setChargeCode($chargeCode)
            ->setChargeType($chargeType)
            ->setChargeAmount($chargeAmount)
            ->setChargeName($chargeName)
            ->setChargeCurrencyCode($chargeCurrencyCode);
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCode, true), gettype($chargeCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($chargeCode) && mb_strlen($chargeCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get ChargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @param string $chargeType
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeType, true), gettype($chargeType)), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return string|null
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param string $chargeAmount
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType
     */
    public function setChargeAmount($chargeAmount = null)
    {
        // validation for constraint: string
        if (!is_null($chargeAmount) && !is_string($chargeAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeAmount, true), gettype($chargeAmount)), __LINE__);
        }
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get ChargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->ChargeName;
    }
    /**
     * Set ChargeName value
     * @param string $chargeName
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeName, true), gettype($chargeName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($chargeName) && mb_strlen($chargeName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($chargeName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chargeName) && mb_strlen($chargeName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chargeName)), __LINE__);
        }
        $this->ChargeName = $chargeName;
        return $this;
    }
    /**
     * Get ChargeCurrencyCode value
     * @return string|null
     */
    public function getChargeCurrencyCode()
    {
        return $this->ChargeCurrencyCode;
    }
    /**
     * Set ChargeCurrencyCode value
     * @param string $chargeCurrencyCode
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType
     */
    public function setChargeCurrencyCode($chargeCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCurrencyCode) && !is_string($chargeCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeCurrencyCode, true), gettype($chargeCurrencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($chargeCurrencyCode) && mb_strlen($chargeCurrencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($chargeCurrencyCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chargeCurrencyCode) && mb_strlen($chargeCurrencyCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chargeCurrencyCode)), __LINE__);
        }
        $this->ChargeCurrencyCode = $chargeCurrencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \DHLExpressGlobalWS\StructType\DocTypeRef_ChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
