<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMaterial StructType
 * @subpackage Structs
 */
class GetMaterial extends AbstractStructBase
{
    /**
     * The Material
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Material;
    /**
     * The SafeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SafeKey;
    /**
     * Constructor method for GetMaterial
     * @uses GetMaterial::setMaterial()
     * @uses GetMaterial::setSafeKey()
     * @param string $material
     * @param string $safeKey
     */
    public function __construct($material = null, $safeKey = null)
    {
        $this
            ->setMaterial($material)
            ->setSafeKey($safeKey);
    }
    /**
     * Get Material value
     * @return string|null
     */
    public function getMaterial()
    {
        return $this->Material;
    }
    /**
     * Set Material value
     * @param string $material
     * @return \Farfetch\StructType\GetMaterial
     */
    public function setMaterial($material = null)
    {
        // validation for constraint: string
        if (!is_null($material) && !is_string($material)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($material, true), gettype($material)), __LINE__);
        }
        $this->Material = $material;
        return $this;
    }
    /**
     * Get SafeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->SafeKey;
    }
    /**
     * Set SafeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetMaterial
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->SafeKey = $safeKey;
        return $this;
    }
}
