<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociateProduct StructType
 * @subpackage Structs
 */
class AssociateProduct extends AbstractStructBase
{
    /**
     * The storeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeId;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $itemId;
    /**
     * The boutiquePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $boutiquePrice;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The sku
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The barcodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\ArrayType\ArrayOfSimpleBoutiqueBarcode
     */
    public $barcodes;
    /**
     * Constructor method for AssociateProduct
     * @uses AssociateProduct::setStoreId()
     * @uses AssociateProduct::setItemId()
     * @uses AssociateProduct::setBoutiquePrice()
     * @uses AssociateProduct::setSafeKey()
     * @uses AssociateProduct::setSku()
     * @uses AssociateProduct::setBarcodes()
     * @param int $storeId
     * @param int $itemId
     * @param float $boutiquePrice
     * @param string $safeKey
     * @param string $sku
     * @param \Farfetch\ArrayType\ArrayOfSimpleBoutiqueBarcode $barcodes
     */
    public function __construct($storeId = null, $itemId = null, $boutiquePrice = null, $safeKey = null, $sku = null, \Farfetch\ArrayType\ArrayOfSimpleBoutiqueBarcode $barcodes = null)
    {
        $this
            ->setStoreId($storeId)
            ->setItemId($itemId)
            ->setBoutiquePrice($boutiquePrice)
            ->setSafeKey($safeKey)
            ->setSku($sku)
            ->setBarcodes($barcodes);
    }
    /**
     * Get storeId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->storeId;
    }
    /**
     * Set storeId value
     * @param int $storeId
     * @return \Farfetch\StructType\AssociateProduct
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->storeId = $storeId;
        return $this;
    }
    /**
     * Get itemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param int $itemId
     * @return \Farfetch\StructType\AssociateProduct
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get boutiquePrice value
     * @return float
     */
    public function getBoutiquePrice()
    {
        return $this->boutiquePrice;
    }
    /**
     * Set boutiquePrice value
     * @param float $boutiquePrice
     * @return \Farfetch\StructType\AssociateProduct
     */
    public function setBoutiquePrice($boutiquePrice = null)
    {
        // validation for constraint: float
        if (!is_null($boutiquePrice) && !(is_float($boutiquePrice) || is_numeric($boutiquePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($boutiquePrice, true), gettype($boutiquePrice)), __LINE__);
        }
        $this->boutiquePrice = $boutiquePrice;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\AssociateProduct
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \Farfetch\StructType\AssociateProduct
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get barcodes value
     * @return \Farfetch\ArrayType\ArrayOfSimpleBoutiqueBarcode|null
     */
    public function getBarcodes()
    {
        return $this->barcodes;
    }
    /**
     * Set barcodes value
     * @param \Farfetch\ArrayType\ArrayOfSimpleBoutiqueBarcode $barcodes
     * @return \Farfetch\StructType\AssociateProduct
     */
    public function setBarcodes(\Farfetch\ArrayType\ArrayOfSimpleBoutiqueBarcode $barcodes = null)
    {
        $this->barcodes = $barcodes;
        return $this;
    }
}
