<?php

namespace Farfetch\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertMaterials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\InsertMaterials $parameters
     * @return \Farfetch\StructType\InsertMaterialsResponse|bool
     */
    public function InsertMaterials(\Farfetch\StructType\InsertMaterials $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertMaterials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertSizesQuantity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\InsertSizesQuantity $parameters
     * @return \Farfetch\StructType\InsertSizesQuantityResponse|bool
     */
    public function InsertSizesQuantity(\Farfetch\StructType\InsertSizesQuantity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertSizesQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertStoreBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\InsertStoreBarcode $parameters
     * @return \Farfetch\StructType\InsertStoreBarcodeResponse|bool
     */
    public function InsertStoreBarcode(\Farfetch\StructType\InsertStoreBarcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertStoreBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Farfetch\StructType\InsertMaterialsResponse|\Farfetch\StructType\InsertSizesQuantityResponse|\Farfetch\StructType\InsertStoreBarcodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
