<?php

namespace Farfetch\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getnd ServiceType
 * @subpackage Services
 */
class Getnd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Get2ndLevelCats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\Get2ndLevelCats $parameters
     * @return \Farfetch\StructType\Get2ndLevelCatsResponse|bool
     */
    public function Get2ndLevelCats(\Farfetch\StructType\Get2ndLevelCats $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Get2ndLevelCats($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Farfetch\StructType\Get2ndLevelCatsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
