<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MappDuplicates StructType
 * @subpackage Structs
 */
class MappDuplicates extends AbstractStructBase
{
    /**
     * The parentStoreId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $parentStoreId;
    /**
     * The parentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $parentId;
    /**
     * The childStoreId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $childStoreId;
    /**
     * The childId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $childId;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The errorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * Constructor method for MappDuplicates
     * @uses MappDuplicates::setParentStoreId()
     * @uses MappDuplicates::setParentId()
     * @uses MappDuplicates::setChildStoreId()
     * @uses MappDuplicates::setChildId()
     * @uses MappDuplicates::setSafeKey()
     * @uses MappDuplicates::setErrorMessage()
     * @param int $parentStoreId
     * @param int $parentId
     * @param int $childStoreId
     * @param int $childId
     * @param string $safeKey
     * @param string $errorMessage
     */
    public function __construct($parentStoreId = null, $parentId = null, $childStoreId = null, $childId = null, $safeKey = null, $errorMessage = null)
    {
        $this
            ->setParentStoreId($parentStoreId)
            ->setParentId($parentId)
            ->setChildStoreId($childStoreId)
            ->setChildId($childId)
            ->setSafeKey($safeKey)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get parentStoreId value
     * @return int
     */
    public function getParentStoreId()
    {
        return $this->parentStoreId;
    }
    /**
     * Set parentStoreId value
     * @param int $parentStoreId
     * @return \Farfetch\StructType\MappDuplicates
     */
    public function setParentStoreId($parentStoreId = null)
    {
        // validation for constraint: int
        if (!is_null($parentStoreId) && !(is_int($parentStoreId) || ctype_digit($parentStoreId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentStoreId, true), gettype($parentStoreId)), __LINE__);
        }
        $this->parentStoreId = $parentStoreId;
        return $this;
    }
    /**
     * Get parentId value
     * @return int
     */
    public function getParentId()
    {
        return $this->parentId;
    }
    /**
     * Set parentId value
     * @param int $parentId
     * @return \Farfetch\StructType\MappDuplicates
     */
    public function setParentId($parentId = null)
    {
        // validation for constraint: int
        if (!is_null($parentId) && !(is_int($parentId) || ctype_digit($parentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentId, true), gettype($parentId)), __LINE__);
        }
        $this->parentId = $parentId;
        return $this;
    }
    /**
     * Get childStoreId value
     * @return int
     */
    public function getChildStoreId()
    {
        return $this->childStoreId;
    }
    /**
     * Set childStoreId value
     * @param int $childStoreId
     * @return \Farfetch\StructType\MappDuplicates
     */
    public function setChildStoreId($childStoreId = null)
    {
        // validation for constraint: int
        if (!is_null($childStoreId) && !(is_int($childStoreId) || ctype_digit($childStoreId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childStoreId, true), gettype($childStoreId)), __LINE__);
        }
        $this->childStoreId = $childStoreId;
        return $this;
    }
    /**
     * Get childId value
     * @return int
     */
    public function getChildId()
    {
        return $this->childId;
    }
    /**
     * Set childId value
     * @param int $childId
     * @return \Farfetch\StructType\MappDuplicates
     */
    public function setChildId($childId = null)
    {
        // validation for constraint: int
        if (!is_null($childId) && !(is_int($childId) || ctype_digit($childId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childId, true), gettype($childId)), __LINE__);
        }
        $this->childId = $childId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\MappDuplicates
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \Farfetch\StructType\MappDuplicates
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\MappDuplicates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
