<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for isBrandVisible StructType
 * @subpackage Structs
 */
class IsBrandVisible extends AbstractStructBase
{
    /**
     * The brandid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $brandid;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for isBrandVisible
     * @uses IsBrandVisible::setBrandid()
     * @uses IsBrandVisible::setSafeKey()
     * @param int $brandid
     * @param string $safeKey
     */
    public function __construct($brandid = null, $safeKey = null)
    {
        $this
            ->setBrandid($brandid)
            ->setSafeKey($safeKey);
    }
    /**
     * Get brandid value
     * @return int
     */
    public function getBrandid()
    {
        return $this->brandid;
    }
    /**
     * Set brandid value
     * @param int $brandid
     * @return \Farfetch\StructType\IsBrandVisible
     */
    public function setBrandid($brandid = null)
    {
        // validation for constraint: int
        if (!is_null($brandid) && !(is_int($brandid) || ctype_digit($brandid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandid, true), gettype($brandid)), __LINE__);
        }
        $this->brandid = $brandid;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\IsBrandVisible
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\IsBrandVisible
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
