<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertStoreBarcode StructType
 * @subpackage Structs
 */
class InsertStoreBarcode extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The StoreId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StoreId;
    /**
     * The Pos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Pos;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The SafeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SafeKey;
    /**
     * Constructor method for InsertStoreBarcode
     * @uses InsertStoreBarcode::setItemId()
     * @uses InsertStoreBarcode::setStoreId()
     * @uses InsertStoreBarcode::setPos()
     * @uses InsertStoreBarcode::setBarcode()
     * @uses InsertStoreBarcode::setSafeKey()
     * @param int $itemId
     * @param int $storeId
     * @param int $pos
     * @param string $barcode
     * @param string $safeKey
     */
    public function __construct($itemId = null, $storeId = null, $pos = null, $barcode = null, $safeKey = null)
    {
        $this
            ->setItemId($itemId)
            ->setStoreId($storeId)
            ->setPos($pos)
            ->setBarcode($barcode)
            ->setSafeKey($safeKey);
    }
    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \Farfetch\StructType\InsertStoreBarcode
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get StoreId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->StoreId;
    }
    /**
     * Set StoreId value
     * @param int $storeId
     * @return \Farfetch\StructType\InsertStoreBarcode
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->StoreId = $storeId;
        return $this;
    }
    /**
     * Get Pos value
     * @return int
     */
    public function getPos()
    {
        return $this->Pos;
    }
    /**
     * Set Pos value
     * @param int $pos
     * @return \Farfetch\StructType\InsertStoreBarcode
     */
    public function setPos($pos = null)
    {
        // validation for constraint: int
        if (!is_null($pos) && !(is_int($pos) || ctype_digit($pos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pos, true), gettype($pos)), __LINE__);
        }
        $this->Pos = $pos;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \Farfetch\StructType\InsertStoreBarcode
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get SafeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->SafeKey;
    }
    /**
     * Set SafeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\InsertStoreBarcode
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->SafeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\InsertStoreBarcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
