<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertSizesQuantity StructType
 * @subpackage Structs
 */
class InsertSizesQuantity extends AbstractStructBase
{
    /**
     * The articleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $articleId;
    /**
     * The sizeRangeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sizeRangeId;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * The size
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $size;
    /**
     * The barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for InsertSizesQuantity
     * @uses InsertSizesQuantity::setArticleId()
     * @uses InsertSizesQuantity::setSizeRangeId()
     * @uses InsertSizesQuantity::setQuantity()
     * @uses InsertSizesQuantity::setSize()
     * @uses InsertSizesQuantity::setBarcode()
     * @uses InsertSizesQuantity::setSafeKey()
     * @param int $articleId
     * @param int $sizeRangeId
     * @param int $quantity
     * @param string $size
     * @param string $barcode
     * @param string $safeKey
     */
    public function __construct($articleId = null, $sizeRangeId = null, $quantity = null, $size = null, $barcode = null, $safeKey = null)
    {
        $this
            ->setArticleId($articleId)
            ->setSizeRangeId($sizeRangeId)
            ->setQuantity($quantity)
            ->setSize($size)
            ->setBarcode($barcode)
            ->setSafeKey($safeKey);
    }
    /**
     * Get articleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \Farfetch\StructType\InsertSizesQuantity
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
    /**
     * Get sizeRangeId value
     * @return int
     */
    public function getSizeRangeId()
    {
        return $this->sizeRangeId;
    }
    /**
     * Set sizeRangeId value
     * @param int $sizeRangeId
     * @return \Farfetch\StructType\InsertSizesQuantity
     */
    public function setSizeRangeId($sizeRangeId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeRangeId) && !(is_int($sizeRangeId) || ctype_digit($sizeRangeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeRangeId, true), gettype($sizeRangeId)), __LINE__);
        }
        $this->sizeRangeId = $sizeRangeId;
        return $this;
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \Farfetch\StructType\InsertSizesQuantity
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param string $size
     * @return \Farfetch\StructType\InsertSizesQuantity
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \Farfetch\StructType\InsertSizesQuantity
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\InsertSizesQuantity
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\InsertSizesQuantity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
