<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStorePriceResponse StructType
 * @subpackage Structs
 */
class GetStorePriceResponse extends AbstractStructBase
{
    /**
     * The GetStorePriceResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GetStorePriceResult;
    /**
     * The StorePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StorePrice;
    /**
     * The WebsitePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $WebsitePrice;
    /**
     * Constructor method for GetStorePriceResponse
     * @uses GetStorePriceResponse::setGetStorePriceResult()
     * @uses GetStorePriceResponse::setStorePrice()
     * @uses GetStorePriceResponse::setWebsitePrice()
     * @param bool $getStorePriceResult
     * @param float $storePrice
     * @param float $websitePrice
     */
    public function __construct($getStorePriceResult = null, $storePrice = null, $websitePrice = null)
    {
        $this
            ->setGetStorePriceResult($getStorePriceResult)
            ->setStorePrice($storePrice)
            ->setWebsitePrice($websitePrice);
    }
    /**
     * Get GetStorePriceResult value
     * @return bool
     */
    public function getGetStorePriceResult()
    {
        return $this->GetStorePriceResult;
    }
    /**
     * Set GetStorePriceResult value
     * @param bool $getStorePriceResult
     * @return \Farfetch\StructType\GetStorePriceResponse
     */
    public function setGetStorePriceResult($getStorePriceResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($getStorePriceResult) && !is_bool($getStorePriceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getStorePriceResult, true), gettype($getStorePriceResult)), __LINE__);
        }
        $this->GetStorePriceResult = $getStorePriceResult;
        return $this;
    }
    /**
     * Get StorePrice value
     * @return float
     */
    public function getStorePrice()
    {
        return $this->StorePrice;
    }
    /**
     * Set StorePrice value
     * @param float $storePrice
     * @return \Farfetch\StructType\GetStorePriceResponse
     */
    public function setStorePrice($storePrice = null)
    {
        // validation for constraint: float
        if (!is_null($storePrice) && !(is_float($storePrice) || is_numeric($storePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($storePrice, true), gettype($storePrice)), __LINE__);
        }
        $this->StorePrice = $storePrice;
        return $this;
    }
    /**
     * Get WebsitePrice value
     * @return float
     */
    public function getWebsitePrice()
    {
        return $this->WebsitePrice;
    }
    /**
     * Set WebsitePrice value
     * @param float $websitePrice
     * @return \Farfetch\StructType\GetStorePriceResponse
     */
    public function setWebsitePrice($websitePrice = null)
    {
        // validation for constraint: float
        if (!is_null($websitePrice) && !(is_float($websitePrice) || is_numeric($websitePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($websitePrice, true), gettype($websitePrice)), __LINE__);
        }
        $this->WebsitePrice = $websitePrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\GetStorePriceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
