<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSizes StructType
 * @subpackage Structs
 */
class GetSizes extends AbstractStructBase
{
    /**
     * The sizeRangeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $sizeRangeId;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for GetSizes
     * @uses GetSizes::setSizeRangeId()
     * @uses GetSizes::setSafeKey()
     * @param int $sizeRangeId
     * @param string $safeKey
     */
    public function __construct($sizeRangeId = null, $safeKey = null)
    {
        $this
            ->setSizeRangeId($sizeRangeId)
            ->setSafeKey($safeKey);
    }
    /**
     * Get sizeRangeId value
     * @return int
     */
    public function getSizeRangeId()
    {
        return $this->sizeRangeId;
    }
    /**
     * Set sizeRangeId value
     * @param int $sizeRangeId
     * @return \Farfetch\StructType\GetSizes
     */
    public function setSizeRangeId($sizeRangeId = null)
    {
        // validation for constraint: int
        if (!is_null($sizeRangeId) && !(is_int($sizeRangeId) || ctype_digit($sizeRangeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeRangeId, true), gettype($sizeRangeId)), __LINE__);
        }
        $this->sizeRangeId = $sizeRangeId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetSizes
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\GetSizes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
