<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProperty StructType
 * @subpackage Structs
 */
class GetProperty extends AbstractStructBase
{
    /**
     * The propertyType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $propertyType;
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for GetProperty
     * @uses GetProperty::setPropertyType()
     * @uses GetProperty::setItemID()
     * @uses GetProperty::setSafeKey()
     * @param string $propertyType
     * @param string $itemID
     * @param string $safeKey
     */
    public function __construct($propertyType = null, $itemID = null, $safeKey = null)
    {
        $this
            ->setPropertyType($propertyType)
            ->setItemID($itemID)
            ->setSafeKey($safeKey);
    }
    /**
     * Get propertyType value
     * @return string|null
     */
    public function getPropertyType()
    {
        return $this->propertyType;
    }
    /**
     * Set propertyType value
     * @param string $propertyType
     * @return \Farfetch\StructType\GetProperty
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyType) && !is_string($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyType, true), gettype($propertyType)), __LINE__);
        }
        $this->propertyType = $propertyType;
        return $this;
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \Farfetch\StructType\GetProperty
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetProperty
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\GetProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
