<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPossibleDuplicates StructType
 * @subpackage Structs
 */
class GetPossibleDuplicates extends AbstractStructBase
{
    /**
     * The storeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeId;
    /**
     * The brandId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $brandId;
    /**
     * The safeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * The designerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $designerId;
    /**
     * Constructor method for GetPossibleDuplicates
     * @uses GetPossibleDuplicates::setStoreId()
     * @uses GetPossibleDuplicates::setBrandId()
     * @uses GetPossibleDuplicates::setSafeKey()
     * @uses GetPossibleDuplicates::setDesignerId()
     * @param int $storeId
     * @param int $brandId
     * @param string $safeKey
     * @param string $designerId
     */
    public function __construct($storeId = null, $brandId = null, $safeKey = null, $designerId = null)
    {
        $this
            ->setStoreId($storeId)
            ->setBrandId($brandId)
            ->setSafeKey($safeKey)
            ->setDesignerId($designerId);
    }
    /**
     * Get storeId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->storeId;
    }
    /**
     * Set storeId value
     * @param int $storeId
     * @return \Farfetch\StructType\GetPossibleDuplicates
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->storeId = $storeId;
        return $this;
    }
    /**
     * Get brandId value
     * @return int
     */
    public function getBrandId()
    {
        return $this->brandId;
    }
    /**
     * Set brandId value
     * @param int $brandId
     * @return \Farfetch\StructType\GetPossibleDuplicates
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !(is_int($brandId) || ctype_digit($brandId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($brandId, true), gettype($brandId)), __LINE__);
        }
        $this->brandId = $brandId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetPossibleDuplicates
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
    /**
     * Get designerId value
     * @return string|null
     */
    public function getDesignerId()
    {
        return $this->designerId;
    }
    /**
     * Set designerId value
     * @param string $designerId
     * @return \Farfetch\StructType\GetPossibleDuplicates
     */
    public function setDesignerId($designerId = null)
    {
        // validation for constraint: string
        if (!is_null($designerId) && !is_string($designerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designerId, true), gettype($designerId)), __LINE__);
        }
        $this->designerId = $designerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\GetPossibleDuplicates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
