<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFFItemUrl StructType
 * @subpackage Structs
 */
class GetFFItemUrl extends AbstractStructBase
{
    /**
     * The storeid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $storeid;
    /**
     * The sku
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sku;
    /**
     * The SpecialSafeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialSafeKey;
    /**
     * The urlPartner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlPartner;
    /**
     * Constructor method for GetFFItemUrl
     * @uses GetFFItemUrl::setStoreid()
     * @uses GetFFItemUrl::setSku()
     * @uses GetFFItemUrl::setSpecialSafeKey()
     * @uses GetFFItemUrl::setUrlPartner()
     * @param int $storeid
     * @param string $sku
     * @param string $specialSafeKey
     * @param string $urlPartner
     */
    public function __construct($storeid = null, $sku = null, $specialSafeKey = null, $urlPartner = null)
    {
        $this
            ->setStoreid($storeid)
            ->setSku($sku)
            ->setSpecialSafeKey($specialSafeKey)
            ->setUrlPartner($urlPartner);
    }
    /**
     * Get storeid value
     * @return int
     */
    public function getStoreid()
    {
        return $this->storeid;
    }
    /**
     * Set storeid value
     * @param int $storeid
     * @return \Farfetch\StructType\GetFFItemUrl
     */
    public function setStoreid($storeid = null)
    {
        // validation for constraint: int
        if (!is_null($storeid) && !(is_int($storeid) || ctype_digit($storeid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeid, true), gettype($storeid)), __LINE__);
        }
        $this->storeid = $storeid;
        return $this;
    }
    /**
     * Get sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->sku;
    }
    /**
     * Set sku value
     * @param string $sku
     * @return \Farfetch\StructType\GetFFItemUrl
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->sku = $sku;
        return $this;
    }
    /**
     * Get SpecialSafeKey value
     * @return string|null
     */
    public function getSpecialSafeKey()
    {
        return $this->SpecialSafeKey;
    }
    /**
     * Set SpecialSafeKey value
     * @param string $specialSafeKey
     * @return \Farfetch\StructType\GetFFItemUrl
     */
    public function setSpecialSafeKey($specialSafeKey = null)
    {
        // validation for constraint: string
        if (!is_null($specialSafeKey) && !is_string($specialSafeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialSafeKey, true), gettype($specialSafeKey)), __LINE__);
        }
        $this->SpecialSafeKey = $specialSafeKey;
        return $this;
    }
    /**
     * Get urlPartner value
     * @return string|null
     */
    public function getUrlPartner()
    {
        return $this->urlPartner;
    }
    /**
     * Set urlPartner value
     * @param string $urlPartner
     * @return \Farfetch\StructType\GetFFItemUrl
     */
    public function setUrlPartner($urlPartner = null)
    {
        // validation for constraint: string
        if (!is_null($urlPartner) && !is_string($urlPartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlPartner, true), gettype($urlPartner)), __LINE__);
        }
        $this->urlPartner = $urlPartner;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\GetFFItemUrl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
