<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetComposition StructType
 * @subpackage Structs
 */
class GetComposition extends AbstractStructBase
{
    /**
     * The ArticleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ArticleId;
    /**
     * The safekey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safekey;
    /**
     * Constructor method for GetComposition
     * @uses GetComposition::setArticleId()
     * @uses GetComposition::setSafekey()
     * @param int $articleId
     * @param string $safekey
     */
    public function __construct($articleId = null, $safekey = null)
    {
        $this
            ->setArticleId($articleId)
            ->setSafekey($safekey);
    }
    /**
     * Get ArticleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param int $articleId
     * @return \Farfetch\StructType\GetComposition
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get safekey value
     * @return string|null
     */
    public function getSafekey()
    {
        return $this->safekey;
    }
    /**
     * Set safekey value
     * @param string $safekey
     * @return \Farfetch\StructType\GetComposition
     */
    public function setSafekey($safekey = null)
    {
        // validation for constraint: string
        if (!is_null($safekey) && !is_string($safekey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safekey, true), gettype($safekey)), __LINE__);
        }
        $this->safekey = $safekey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\GetComposition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
