<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllPicturesByBarcode StructType
 * @subpackage Structs
 */
class GetAllPicturesByBarcode extends AbstractStructBase
{
    /**
     * The StoreId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StoreId;
    /**
     * The Size
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Size;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The SafeKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SafeKey;
    /**
     * Constructor method for GetAllPicturesByBarcode
     * @uses GetAllPicturesByBarcode::setStoreId()
     * @uses GetAllPicturesByBarcode::setSize()
     * @uses GetAllPicturesByBarcode::setBarcode()
     * @uses GetAllPicturesByBarcode::setSafeKey()
     * @param int $storeId
     * @param string $size
     * @param string $barcode
     * @param string $safeKey
     */
    public function __construct($storeId = null, $size = null, $barcode = null, $safeKey = null)
    {
        $this
            ->setStoreId($storeId)
            ->setSize($size)
            ->setBarcode($barcode)
            ->setSafeKey($safeKey);
    }
    /**
     * Get StoreId value
     * @return int
     */
    public function getStoreId()
    {
        return $this->StoreId;
    }
    /**
     * Set StoreId value
     * @param int $storeId
     * @return \Farfetch\StructType\GetAllPicturesByBarcode
     */
    public function setStoreId($storeId = null)
    {
        // validation for constraint: int
        if (!is_null($storeId) && !(is_int($storeId) || ctype_digit($storeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeId, true), gettype($storeId)), __LINE__);
        }
        $this->StoreId = $storeId;
        return $this;
    }
    /**
     * Get Size value
     * @return string
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @uses \Farfetch\EnumType\PhotoSizes::valueIsValid()
     * @uses \Farfetch\EnumType\PhotoSizes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $size
     * @return \Farfetch\StructType\GetAllPicturesByBarcode
     */
    public function setSize($size = null)
    {
        // validation for constraint: enumeration
        if (!\Farfetch\EnumType\PhotoSizes::valueIsValid($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Farfetch\EnumType\PhotoSizes', is_array($size) ? implode(', ', $size) : var_export($size, true), implode(', ', \Farfetch\EnumType\PhotoSizes::getValidValues())), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \Farfetch\StructType\GetAllPicturesByBarcode
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get SafeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->SafeKey;
    }
    /**
     * Set SafeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetAllPicturesByBarcode
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->SafeKey = $safeKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\StructType\GetAllPicturesByBarcode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
