<?php

namespace Farfetch\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Is ServiceType
 * @subpackage Services
 */
class Is extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named isBrandVisible
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\IsBrandVisible $parameters
     * @return \Farfetch\StructType\IsBrandVisibleResponse|bool
     */
    public function isBrandVisible(\Farfetch\StructType\IsBrandVisible $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->isBrandVisible($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IsBrandSeasonDesignerIdListBound
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\IsBrandSeasonDesignerIdListBound $parameters
     * @return \Farfetch\StructType\IsBrandSeasonDesignerIdListBoundResponse|bool
     */
    public function IsBrandSeasonDesignerIdListBound(\Farfetch\StructType\IsBrandSeasonDesignerIdListBound $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->IsBrandSeasonDesignerIdListBound($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Farfetch\StructType\IsBrandSeasonDesignerIdListBoundResponse|\Farfetch\StructType\IsBrandVisibleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
