<?php

namespace Farfetch\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\CreateProduct $parameters
     * @return \Farfetch\StructType\CreateProductResponse|bool
     */
    public function CreateProduct(\Farfetch\StructType\CreateProduct $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateProduct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateProductWithUuid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\CreateProductWithUuid $parameters
     * @return \Farfetch\StructType\CreateProductWithUuidResponse|bool
     */
    public function CreateProductWithUuid(\Farfetch\StructType\CreateProductWithUuid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateProductWithUuid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateProductWithUuidAndVat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Farfetch\StructType\CreateProductWithUuidAndVat $parameters
     * @return \Farfetch\StructType\CreateProductWithUuidAndVatResponse|bool
     */
    public function CreateProductWithUuidAndVat(\Farfetch\StructType\CreateProductWithUuidAndVat $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateProductWithUuidAndVat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Farfetch\StructType\CreateProductResponse|\Farfetch\StructType\CreateProductWithUuidAndVatResponse|\Farfetch\StructType\CreateProductWithUuidResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
