<?php

namespace Farfetch\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductSummary ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductSummary extends AbstractStructArrayBase
{
    /**
     * The ProductSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Farfetch\StructType\ProductSummary[]
     */
    public $ProductSummary;
    /**
     * Constructor method for ArrayOfProductSummary
     * @uses ArrayOfProductSummary::setProductSummary()
     * @param \Farfetch\StructType\ProductSummary[] $productSummary
     */
    public function __construct(array $productSummary = array())
    {
        $this
            ->setProductSummary($productSummary);
    }
    /**
     * Get ProductSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Farfetch\StructType\ProductSummary[]|null
     */
    public function getProductSummary()
    {
        return isset($this->ProductSummary) ? $this->ProductSummary : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductSummaryForArrayConstraintsFromSetProductSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProductSummaryProductSummaryItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductSummaryProductSummaryItem instanceof \Farfetch\StructType\ProductSummary) {
                $invalidValues[] = is_object($arrayOfProductSummaryProductSummaryItem) ? get_class($arrayOfProductSummaryProductSummaryItem) : sprintf('%s(%s)', gettype($arrayOfProductSummaryProductSummaryItem), var_export($arrayOfProductSummaryProductSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProductSummary property can only contain items of type \Farfetch\StructType\ProductSummary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProductSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Farfetch\StructType\ProductSummary[] $productSummary
     * @return \Farfetch\ArrayType\ArrayOfProductSummary
     */
    public function setProductSummary(array $productSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($productSummaryArrayErrorMessage = self::validateProductSummaryForArrayConstraintsFromSetProductSummary($productSummary))) {
            throw new \InvalidArgumentException($productSummaryArrayErrorMessage, __LINE__);
        }
        if (is_null($productSummary) || (is_array($productSummary) && empty($productSummary))) {
            unset($this->ProductSummary);
        } else {
            $this->ProductSummary = $productSummary;
        }
        return $this;
    }
    /**
     * Add item to ProductSummary value
     * @throws \InvalidArgumentException
     * @param \Farfetch\StructType\ProductSummary $item
     * @return \Farfetch\ArrayType\ArrayOfProductSummary
     */
    public function addToProductSummary(\Farfetch\StructType\ProductSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Farfetch\StructType\ProductSummary) {
            throw new \InvalidArgumentException(sprintf('The ProductSummary property can only contain items of type \Farfetch\StructType\ProductSummary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProductSummary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Farfetch\StructType\ProductSummary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Farfetch\StructType\ProductSummary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Farfetch\StructType\ProductSummary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Farfetch\StructType\ProductSummary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Farfetch\StructType\ProductSummary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductSummary
     */
    public function getAttributeName()
    {
        return 'ProductSummary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\ArrayType\ArrayOfProductSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
