<?php

namespace Farfetch\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemSize ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemSize extends AbstractStructArrayBase
{
    /**
     * The ItemSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Farfetch\StructType\ItemSize[]
     */
    public $ItemSize;
    /**
     * Constructor method for ArrayOfItemSize
     * @uses ArrayOfItemSize::setItemSize()
     * @param \Farfetch\StructType\ItemSize[] $itemSize
     */
    public function __construct(array $itemSize = array())
    {
        $this
            ->setItemSize($itemSize);
    }
    /**
     * Get ItemSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Farfetch\StructType\ItemSize[]|null
     */
    public function getItemSize()
    {
        return isset($this->ItemSize) ? $this->ItemSize : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemSize method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemSize method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemSizeForArrayConstraintsFromSetItemSize(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemSizeItemSizeItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemSizeItemSizeItem instanceof \Farfetch\StructType\ItemSize) {
                $invalidValues[] = is_object($arrayOfItemSizeItemSizeItem) ? get_class($arrayOfItemSizeItemSizeItem) : sprintf('%s(%s)', gettype($arrayOfItemSizeItemSizeItem), var_export($arrayOfItemSizeItemSizeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemSize property can only contain items of type \Farfetch\StructType\ItemSize, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Farfetch\StructType\ItemSize[] $itemSize
     * @return \Farfetch\ArrayType\ArrayOfItemSize
     */
    public function setItemSize(array $itemSize = array())
    {
        // validation for constraint: array
        if ('' !== ($itemSizeArrayErrorMessage = self::validateItemSizeForArrayConstraintsFromSetItemSize($itemSize))) {
            throw new \InvalidArgumentException($itemSizeArrayErrorMessage, __LINE__);
        }
        if (is_null($itemSize) || (is_array($itemSize) && empty($itemSize))) {
            unset($this->ItemSize);
        } else {
            $this->ItemSize = $itemSize;
        }
        return $this;
    }
    /**
     * Add item to ItemSize value
     * @throws \InvalidArgumentException
     * @param \Farfetch\StructType\ItemSize $item
     * @return \Farfetch\ArrayType\ArrayOfItemSize
     */
    public function addToItemSize(\Farfetch\StructType\ItemSize $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Farfetch\StructType\ItemSize) {
            throw new \InvalidArgumentException(sprintf('The ItemSize property can only contain items of type \Farfetch\StructType\ItemSize, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemSize[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Farfetch\StructType\ItemSize|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Farfetch\StructType\ItemSize|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Farfetch\StructType\ItemSize|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Farfetch\StructType\ItemSize|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Farfetch\StructType\ItemSize|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemSize
     */
    public function getAttributeName()
    {
        return 'ItemSize';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\ArrayType\ArrayOfItemSize
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
