<?php

namespace Farfetch\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGeoRegion ArrayType
 * @subpackage Arrays
 */
class ArrayOfGeoRegion extends AbstractStructArrayBase
{
    /**
     * The GeoRegion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Farfetch\StructType\GeoRegion[]
     */
    public $GeoRegion;
    /**
     * Constructor method for ArrayOfGeoRegion
     * @uses ArrayOfGeoRegion::setGeoRegion()
     * @param \Farfetch\StructType\GeoRegion[] $geoRegion
     */
    public function __construct(array $geoRegion = array())
    {
        $this
            ->setGeoRegion($geoRegion);
    }
    /**
     * Get GeoRegion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Farfetch\StructType\GeoRegion[]|null
     */
    public function getGeoRegion()
    {
        return isset($this->GeoRegion) ? $this->GeoRegion : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGeoRegion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeoRegion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeoRegionForArrayConstraintsFromSetGeoRegion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGeoRegionGeoRegionItem) {
            // validation for constraint: itemType
            if (!$arrayOfGeoRegionGeoRegionItem instanceof \Farfetch\StructType\GeoRegion) {
                $invalidValues[] = is_object($arrayOfGeoRegionGeoRegionItem) ? get_class($arrayOfGeoRegionGeoRegionItem) : sprintf('%s(%s)', gettype($arrayOfGeoRegionGeoRegionItem), var_export($arrayOfGeoRegionGeoRegionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GeoRegion property can only contain items of type \Farfetch\StructType\GeoRegion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeoRegion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Farfetch\StructType\GeoRegion[] $geoRegion
     * @return \Farfetch\ArrayType\ArrayOfGeoRegion
     */
    public function setGeoRegion(array $geoRegion = array())
    {
        // validation for constraint: array
        if ('' !== ($geoRegionArrayErrorMessage = self::validateGeoRegionForArrayConstraintsFromSetGeoRegion($geoRegion))) {
            throw new \InvalidArgumentException($geoRegionArrayErrorMessage, __LINE__);
        }
        if (is_null($geoRegion) || (is_array($geoRegion) && empty($geoRegion))) {
            unset($this->GeoRegion);
        } else {
            $this->GeoRegion = $geoRegion;
        }
        return $this;
    }
    /**
     * Add item to GeoRegion value
     * @throws \InvalidArgumentException
     * @param \Farfetch\StructType\GeoRegion $item
     * @return \Farfetch\ArrayType\ArrayOfGeoRegion
     */
    public function addToGeoRegion(\Farfetch\StructType\GeoRegion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Farfetch\StructType\GeoRegion) {
            throw new \InvalidArgumentException(sprintf('The GeoRegion property can only contain items of type \Farfetch\StructType\GeoRegion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GeoRegion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Farfetch\StructType\GeoRegion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Farfetch\StructType\GeoRegion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Farfetch\StructType\GeoRegion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Farfetch\StructType\GeoRegion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Farfetch\StructType\GeoRegion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GeoRegion
     */
    public function getAttributeName()
    {
        return 'GeoRegion';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Farfetch\ArrayType\ArrayOfGeoRegion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
