<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMeasures StructType
 * @subpackage Structs
 */
class GetMeasures extends AbstractStructBase
{
    /**
     * The ArticleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ArticleId;
    /**
     * The safeKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $safeKey;
    /**
     * Constructor method for GetMeasures
     * @uses GetMeasures::setArticleId()
     * @uses GetMeasures::setSafeKey()
     * @param int $articleId
     * @param string $safeKey
     */
    public function __construct($articleId = null, $safeKey = null)
    {
        $this
            ->setArticleId($articleId)
            ->setSafeKey($safeKey);
    }
    /**
     * Get ArticleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->ArticleId;
    }
    /**
     * Set ArticleId value
     * @param int $articleId
     * @return \Farfetch\StructType\GetMeasures
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->ArticleId = $articleId;
        return $this;
    }
    /**
     * Get safeKey value
     * @return string|null
     */
    public function getSafeKey()
    {
        return $this->safeKey;
    }
    /**
     * Set safeKey value
     * @param string $safeKey
     * @return \Farfetch\StructType\GetMeasures
     */
    public function setSafeKey($safeKey = null)
    {
        // validation for constraint: string
        if (!is_null($safeKey) && !is_string($safeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safeKey, true), gettype($safeKey)), __LINE__);
        }
        $this->safeKey = $safeKey;
        return $this;
    }
}
