<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateProductResponse StructType
 * @subpackage Structs
 */
class CreateProductResponse extends AbstractStructBase
{
    /**
     * The CreateProductResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CreateProductResult;
    /**
     * The articleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $articleId;
    /**
     * Constructor method for CreateProductResponse
     * @uses CreateProductResponse::setCreateProductResult()
     * @uses CreateProductResponse::setArticleId()
     * @param bool $createProductResult
     * @param int $articleId
     */
    public function __construct($createProductResult = null, $articleId = null)
    {
        $this
            ->setCreateProductResult($createProductResult)
            ->setArticleId($articleId);
    }
    /**
     * Get CreateProductResult value
     * @return bool
     */
    public function getCreateProductResult()
    {
        return $this->CreateProductResult;
    }
    /**
     * Set CreateProductResult value
     * @param bool $createProductResult
     * @return \Farfetch\StructType\CreateProductResponse
     */
    public function setCreateProductResult($createProductResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($createProductResult) && !is_bool($createProductResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createProductResult, true), gettype($createProductResult)), __LINE__);
        }
        $this->CreateProductResult = $createProductResult;
        return $this;
    }
    /**
     * Get articleId value
     * @return int
     */
    public function getArticleId()
    {
        return $this->articleId;
    }
    /**
     * Set articleId value
     * @param int $articleId
     * @return \Farfetch\StructType\CreateProductResponse
     */
    public function setArticleId($articleId = null)
    {
        // validation for constraint: int
        if (!is_null($articleId) && !(is_int($articleId) || ctype_digit($articleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($articleId, true), gettype($articleId)), __LINE__);
        }
        $this->articleId = $articleId;
        return $this;
    }
}
