<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationProperty StructType
 * @subpackage Structs
 */
class TransportationProperty extends AbstractStructBase
{
    /**
     * The PropertyId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PropertyId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for TransportationProperty
     * @uses TransportationProperty::setPropertyId()
     * @uses TransportationProperty::setDescription()
     * @param int $propertyId
     * @param string $description
     */
    public function __construct($propertyId = null, $description = null)
    {
        $this
            ->setPropertyId($propertyId)
            ->setDescription($description);
    }
    /**
     * Get PropertyId value
     * @return int
     */
    public function getPropertyId()
    {
        return $this->PropertyId;
    }
    /**
     * Set PropertyId value
     * @param int $propertyId
     * @return \Farfetch\StructType\TransportationProperty
     */
    public function setPropertyId($propertyId = null)
    {
        // validation for constraint: int
        if (!is_null($propertyId) && !(is_int($propertyId) || ctype_digit($propertyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propertyId, true), gettype($propertyId)), __LINE__);
        }
        $this->PropertyId = $propertyId;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Farfetch\StructType\TransportationProperty
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
