<?php

namespace Farfetch\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationProduct StructType
 * @subpackage Structs
 */
class TransportationProduct extends AbstractStructBase
{
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductId;
    /**
     * The Properties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Farfetch\ArrayType\ArrayOfTransportationProperty
     */
    public $Properties;
    /**
     * Constructor method for TransportationProduct
     * @uses TransportationProduct::setProductId()
     * @uses TransportationProduct::setProperties()
     * @param int $productId
     * @param \Farfetch\ArrayType\ArrayOfTransportationProperty $properties
     */
    public function __construct($productId = null, \Farfetch\ArrayType\ArrayOfTransportationProperty $properties = null)
    {
        $this
            ->setProductId($productId)
            ->setProperties($properties);
    }
    /**
     * Get ProductId value
     * @return int
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \Farfetch\StructType\TransportationProduct
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get Properties value
     * @return \Farfetch\ArrayType\ArrayOfTransportationProperty|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @param \Farfetch\ArrayType\ArrayOfTransportationProperty $properties
     * @return \Farfetch\StructType\TransportationProduct
     */
    public function setProperties(\Farfetch\ArrayType\ArrayOfTransportationProperty $properties = null)
    {
        $this->Properties = $properties;
        return $this;
    }
}
